

<?php $__env->startSection('content'); ?>

<div class="card p-4">

    <h4 class="mb-4">تعديل الترخيص رقم <?php echo e($license->id); ?></h4>

    <form action="<?php echo e(route('committee.licenses.update', $license->id)); ?>"
     method="POST"
    enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        
        <div class="mb-3">
            <label for="status" class="form-label">الحالة</label>
            <select name="status" id="status" class="form-control" required>
                <option value="under_review" <?php echo e($license->status == 'under_review' ? 'selected' : ''); ?>>قيد المراجعة</option>
                <option value="approved" <?php echo e($license->status == 'approved' ? 'selected' : ''); ?>>مقبول</option>
                <option value="rejected" <?php echo e($license->status == 'rejected' ? 'selected' : ''); ?>>مرفوض</option>
            </select>
        </div>

        
  <div class="col-md-6">
    <label class="form-label">المستخدم الحالي</label>
    <input type="text" class="form-control" value="<?php echo e(auth()->user()->name); ?>" disabled>
    <input type="hidden" name="current_user_id" value="<?php echo e(auth()->user()->id); ?>">
</div>


        
        <div class="mb-3">
            <label for="next_user_id" class="form-label">المستخدم التالي</label>
            <select name="next_user_id" id="next_user_id" class="form-control">
                <option value="">اختر مستخدمًا</option>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>" <?php echo e($license->next_user_id == $user->id ? 'selected' : ''); ?>>
                        <?php echo e($user->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        
        <div class="mb-3">
            <label for="note" class="form-label">ملاحظات</label>
            <textarea name="note" id="note" class="form-control"><?php echo e($license->note); ?></textarea>
        </div>

        
        <div class="mb-3">
            <label for="final_status" class="form-label">الحالة النهائية</label>
            <input type="text" name="final_status" id="final_status" class="form-control" value="<?php echo e($license->final_status); ?>">
        </div>


          <div class="form-group mt-3">
    <label for="approval_file">📄 ملف الموافقة (PDF من الوزارة)</label>
    <input type="file" name="approval_file" class="form-control" accept="application/pdf">

 
</div>



        <div class="d-flex justify-content-between mt-4">
            <a href="<?php echo e(route('committee.licenses.index')); ?>" class="btn btn-secondary">إلغاء</a>
            <button type="submit" class="btn btn-success">تحديث</button>
        </div>

    </form>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('committee.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/committee/licenses/edit.blade.php ENDPATH**/ ?>