

<?php $__env->startSection('content'); ?>
<div class="card p-4">
    <h4 class="mb-4">قائمة التراخيص</h4>

    <table class="table table-bordered text-center">
        <thead class="table-dark">
            <tr>
                <th>الرقم</th>
                <th>اسم الفرع</th>
                <th>الحالة</th>
                <th>المستخدم الحالي</th>
                <th>المستخدم التالي</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $licenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $license): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($license->id); ?></td>
                    <td><?php echo e($license->branch->name ?? 'غير متوفر'); ?></td>
                    <td>
                        <?php switch($license->status):
                            case ('under_review'): ?>
                                <span class="badge bg-warning text-dark">قيد المراجعة</span>
                                <?php break; ?>
                            <?php case ('approved'): ?>
                                <span class="badge bg-success">مقبول</span>
                                <?php break; ?>
                            <?php case ('rejected'): ?>
                                <span class="badge bg-danger">مرفوض</span>
                                <?php break; ?>
                            <?php default: ?>
                                <span class="badge bg-secondary">غير معروف</span>
                        <?php endswitch; ?>
                    </td>
                    <td><?php echo e($license->currentUser->name ?? '---'); ?></td>
                    <td><?php echo e($license->nextUser->name ?? '---'); ?></td>
                    <td>
    <a href="<?php echo e(route('committee.licenses.add', $license->id)); ?>" class="btn btn-sm btn-primary">عرض</a>

    <a href="<?php echo e(route('committee.licenses.edit', $license->id)); ?>" class="btn btn-sm btn-warning">تعديل</a>

    <form action="<?php echo e(route('committee.licenses.destroy', $license->id)); ?>" method="POST" style="display:inline-block;" onsubmit="return confirm('هل تريد حذف هذا الترخيص؟');">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <button type="submit" class="btn btn-sm btn-danger">حذف</button>
    </form>
</td>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('committee.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/committee/licenses/index.blade.php ENDPATH**/ ?>