

<?php $__env->startSection('content'); ?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>إضافة فرع جديد</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            direction: rtl;
            background: #f5f7fa;
            padding: 30px;
            color: #333;
        }
        h2 {
            text-align: center;
            margin-bottom: 25px;
            color: #2c3e50;
        }
        form {
            max-width: 900px;
            margin: 0 auto;
            background: #fff;
            padding: 25px 30px;
            border-radius: 10px;
            box-shadow: 0 0 15px rgb(0 0 0 / 0.1);
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px 30px;
        }
        label {
            display: block;
            margin-bottom: 6px;
            font-weight: 600;
            color: #34495e;
        }
        input[type="text"],
        input[type="file"],
        select {
            width: 100%;
            padding: 10px 12px;
            border: 1.8px solid #bdc3c7;
            border-radius: 6px;
            font-size: 15px;
            transition: border-color 0.3s;
        }
        input[type="text"]:focus,
        select:focus {
            border-color: #27ae60;
            outline: none;
            box-shadow: 0 0 8px #27ae6011;
        }
        /* اجعل الحقول من نوع file أصغر قليلاً */
        input[type="file"] {
            padding: 6px 10px;
            font-size: 14px;
        }
        /* عرض الخريطة */
        #map {
            grid-column: span 2;
            height: 350px;
            border-radius: 8px;
            border: 1.5px solid #ccc;
        }
        /* زر الحفظ */
        button[type="submit"] {
            grid-column: span 2;
            background-color: #27ae60;
            color: white;
            font-weight: 700;
            padding: 12px 0;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 18px;
            transition: background-color 0.25s;
            margin-top: 20px;
        }
        button[type="submit"]:hover {
            background-color: #1e8449;
        }
        /* إذا أردت عرض الرسائل */
        .success-message {
            grid-column: span 2;
            background-color: #dff0d8;
            color: #3c763d;
            border: 1px solid #d0e9c6;
            padding: 10px 15px;
            border-radius: 6px;
            margin-bottom: 15px;
            font-weight: 600;
        }
    </style>
</head>
<body>

<h2>إضافة فرع مدرسة جديد</h2>

<?php if(session('success')): ?>
    <div class="success-message"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<form method="POST" action="<?php echo e(route('branches.store')); ?>" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>

    <div>
        <label for="school_id">اسم المدرسة:</label>
        <select name="school_id" id="school_id" required>
            <option value=""> اختر المدرسة </option>
            <?php $__currentLoopData = $schools; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($school->id); ?>"><?php echo e($school->school_name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div>
        <label for="area_id">اسم المنطقة:</label>
        <select name="area_id" id="area_id" required>
            <option value=""> اختر المنطقة </option>
            <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($area->id); ?>"><?php echo e($area->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div>
        <label for="name">اسم الفرع:</label>
        <input type="text" id="name" name="name" placeholder="أدخل اسم الفرع" required />
    </div>

    <div>
        <label for="school_address">العنوان:</label>
        <input type="text" id="school_address" name="school_address" placeholder="عنوان الفرع" />
    </div>

    <div>
        <label for="nearest_landmark">أقرب معلم بارز:</label>
        <input type="text" id="nearest_landmark" name="nearest_landmark" placeholder="مثال: مسجد، مول" />
    </div>

    <div>
        <label for="name_manage">اسم المدير:</label>
        <input type="text" id="name_manage" name="name_manage" placeholder="اسم مدير الفرع" />
    </div>

    <div>
        <label for="phone_manage">رقم مدير الفرع:</label>
        <input type="text" id="phone_manage" name="phone_manage" placeholder="رقم هاتف المدير" />
    </div>

    <div>
        <label for="phone">رقم الفرع:</label>
        <input type="text" id="phone" name="phone" placeholder="رقم هاتف الفرع" />
    </div>

    <div>
        <label for="description">الوصف:</label>
        <input type="text" id="description" name="description" placeholder="وصف مختصر للفرع" />
    </div>

    <div>
        <label for="cv_manage">CV المدير (PDF):</label>
        <input type="file" id="cv_manage" name="cv_manage" accept=".pdf" />
    </div>

    <div>
        <label for="contrect_image">صورة عقد الإيجار:</label>
        <input type="file" id="contrect_image" name="contrect_image" accept="image/*" />
    </div>

    <div>
        <label for="plan_image">صورة المخطط:</label>
        <input type="file" id="plan_image" name="plan_image" accept="image/*" />
    </div>

    <div>
        <label for="main_image">الصورة الرئيسية:</label>
        <input type="file" id="main_image" name="main_image" accept="image/*" />
    </div>

    <div>
        <label for="secondary_image">الصورة الثانوية:</label>
        <input type="file" id="secondary_image" name="secondary_image" accept="image/*" />
    </div>

    <div>
        <label for="file_feasibility">دراسة الجدوى:</label>
        <input type="file" id="file_feasibility" name="file_feasibility" accept=".pdf,.doc,.docx" />
    </div>

    <div>
        <label for="bank_statement">كشف الحساب البنكي:</label>
        <input type="file" id="bank_statement" name="bank_statement" accept=".pdf,.doc,.docx" />
    </div>

    <div>
        <label for="other_document">وثائق أخرى:</label>
        <input type="file" id="other_document" name="other_document" />
    </div>

    <div>
        <label for="latitude">خط العرض (Latitude):</label>
        <input type="text" id="latitude" name="latitude" value="15.3694" required />
    </div>

    <div>
        <label for="longitude">خط الطول (Longitude):</label>
        <input type="text" id="longitude" name="longitude" value="44.1910" required />
    </div>

    <div id="map"></div>

    <button type="submit">حفظ الفرع</button>
</form>

<script>
    let map, marker;

    function initMap() {
        const latInput = document.getElementById("latitude");
        const lngInput = document.getElementById("longitude");

        let lat = parseFloat(latInput.value) || 15.3694;
        let lng = parseFloat(lngInput.value) || 44.1910;

        const location = { lat, lng };

        map = new google.maps.Map(document.getElementById("map"), {
            center: location,
            zoom: 13,
        });

        marker = new google.maps.Marker({
            position: location,
            map: map,
            draggable: true,
        });

        // تحديث الاحداثيات عند تحريك العلامة
        marker.addListener('dragend', function (event) {
            latInput.value = event.latLng.lat().toFixed(7);
            lngInput.value = event.latLng.lng().toFixed(7);
        });

        // تحديث العلامة عند تغير النصوص يدويًا
        latInput.addEventListener('change', () => updateMarker());
        lngInput.addEventListener('change', () => updateMarker());

        // تحديث العلامة على الخريطة
        function updateMarker() {
            let newLat = parseFloat(latInput.value);
            let newLng = parseFloat(lngInput.value);
            if (!isNaN(newLat) && !isNaN(newLng)) {
                const newPos = { lat: newLat, lng: newLng };
                marker.setPosition(newPos);
                map.panTo(newPos);
            }
        }

        // السماح بالنقر على الخريطة لتغيير الموقع
        map.addListener('click', function (e) {
            const clickedLat = e.latLng.lat();
            const clickedLng = e.latLng.lng();

            latInput.value = clickedLat.toFixed(7);
            lngInput.value = clickedLng.toFixed(7);

            marker.setPosition({ lat: clickedLat, lng: clickedLng });
            map.panTo({ lat: clickedLat, lng: clickedLng });
        });
    }
</script>
<script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(env('GOOGLE_MAPS_API_KEY')); ?>&callback=initMap" async defer></script>

</body>
</html>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/branches/add_branche.blade.php ENDPATH**/ ?>