

<?php $__env->startSection('content'); ?>
<div class="card p-4">
    <h4 class="mb-4">تعديل الترخيص</h4>

    <form method="POST" action="<?php echo e(route('licenses.update', $license->id)); ?>"   enctype="multipart/form-data"">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="mb-3">
            <label class="form-label">اسم الفرع</label>
            <select name="branche_id" class="form-select" required>
                <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($branch->id); ?>" <?php echo e($license->branche_id == $branch->id ? 'selected' : ''); ?>>
                        <?php echo e($branch->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">الحالة</label>
            <select name="status" class="form-select" required>
                <option value="under_review" <?php echo e($license->status == 'under_review' ? 'selected' : ''); ?>>قيد المراجعة</option>
                <option value="approved" <?php echo e($license->status == 'approved' ? 'selected' : ''); ?>>مقبول</option>
                <option value="rejected" <?php echo e($license->status == 'rejected' ? 'selected' : ''); ?>>مرفوض</option>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">المستخدم الحالي</label>
            <select name="current_user_id" class="form-select" required>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>" <?php echo e($license->current_user_id == $user->id ? 'selected' : ''); ?>>
                        <?php echo e($user->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">المستخدم التالي</label>
            <select name="next_user_id" class="form-select" required>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>" <?php echo e($license->next_user_id == $user->id ? 'selected' : ''); ?>>
                        <?php echo e($user->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">الملاحظة</label>
            <input type="text" name="note" class="form-control" value="<?php echo e($license->note); ?>" required>
        </div>

        <div class="mb-3">
            <label class="form-label">الحالة النهائية</label>
            <input type="text" name="final_status" class="form-control" value="<?php echo e($license->final_status); ?>" required>
        </div>



      <div class="form-group mt-3">
    <label for="approval_file">📄 ملف الموافقة (PDF من الوزارة)</label>
    <input type="file" name="approval_file" class="form-control" accept="application/pdf">

 
</div>

        <button type="submit" class="btn btn-primary">حفظ التعديلات</button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/licenses/edit_license.blade.php ENDPATH**/ ?>