


<?php $__env->startSection('title', 'إضافة مدرسة'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h2 class="mb-4">إضافة مدرسة جديدة</h2>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="<?php echo e(route('schools.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <div class="mb-3">
            <label>اسم المدرسة</label>
            <input type="text" name="school_name" class="form-control" value="<?php echo e(old('school_name')); ?>" required>
        </div>

        <div class="mb-3">
            <label>المحافظة</label>
            <select name="city_id" class="form-control" required>
                <option value="">اختر المحافظة</option>
                <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($city->id); ?>" <?php echo e(old('city_id') == $city->id ? 'selected' : ''); ?>>
                        <?php echo e($city->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label>نوع المدرسة</label>
           <div class="form-check">
    <input class="form-check-input" type="checkbox" name="type[]" value="تمهيدي" id="type1">
    <label class="form-check-label" for="type1">تمهيدي</label>
</div>

<div class="form-check">
    <input class="form-check-input" type="checkbox" name="type[]" value="أساسي" id="type2">
    <label class="form-check-label" for="type2">أساسي</label>
</div>

<div class="form-check">
    <input class="form-check-input" type="checkbox" name="type[]" value="إعدادي" id="type3">
    <label class="form-check-label" for="type3">إعدادي</label>
</div>

<div class="form-check">
    <input class="form-check-input" type="checkbox" name="type[]" value="ثانوي" id="type4">
    <label class="form-check-label" for="type4">ثانوي</label>
</div>


      <div class="mb-4">
                    <label for="logo" class="form-label fw-bold">شعار المدرسة (صورة)</label>
                    <input type="file" id="logo" name="logo" class="form-control">
                </div>

        <button type="submit" class="btn btn-success">حفظ</button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('client.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/client/renew/noschool.blade.php ENDPATH**/ ?>