

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <h2 class="mb-4">طلبات تجديد التراخيص لمحافظة <?php echo e($city->name); ?></h2>

    <?php if($renewals->count() > 0): ?>
    <table class="table table-bordered table-striped text-right" dir="rtl">
 
            <table class="table table-bordered align-middle text-center">
                <thead class="table-light">
                    <tr>
                        <th>الرقم</th>
                        <th>اسم المدرسة</th>
                        <th>الفرع</th>
                        <th>المديرية</th>
                        <th>الحالة</th>
                        <th>خيارات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $renewals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $renwel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            <td><?php echo e($renwel->school->school_name ?? '-'); ?></td> <!-- إظهار اسم المدرسة -->
                      <td><?php echo e($renwel->branch_name ?? '-'); ?></td> <!-- إظهار الفرع كاسم -->
                     <td><?php echo e($renwel->area->name ?? '-'); ?></td>
                            <td>
                                <?php switch($renwel->status):
                                    case ('مقبول'): ?>
                                        <span class="badge bg-success">مقبول</span>
                                        <?php break; ?>
                                    <?php case ('مرفوض'): ?>
                                        <span class="badge bg-danger">مرفوض</span>
                                        <?php break; ?>
                                    <?php default: ?>
                                        <span class="badge bg-warning text-dark">قيد المراجعة</span>
                                <?php endswitch; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('committee.show', $renwel->id)); ?>" class="btn btn-sm btn-primary">
                                    <i class="fas fa-eye"></i> عرض
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php else: ?>
    <p>لا توجد طلبات تجديد في هذه المحافظة.</p>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('committee.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/committee/city/byCity.blade.php ENDPATH**/ ?>