

<?php $__env->startSection('content'); ?>

<div class="card p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="mb-0">قائمة المناطق</h2>
        <a href="<?php echo e(route('areas.create')); ?>" class="btn btn-success">إضافة منطقة جديدة</a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <table class="table table-bordered table-striped text-center">
        <thead class="table-light">
            <tr>
                <th>الرقن</th>
                <th>اسم المنطقة</th>
                <th>المدينة</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($area->name); ?></td>
                    <td><?php echo e($area->city->name ?? 'غير محددة'); ?></td>
                    <td>
                        <a href="<?php echo e(route('areas.edit', $area->id)); ?>" class="btn btn-sm btn-warning">تعديل</a>

                        <form action="<?php echo e(route('areas.destroy', $area->id)); ?>" method="POST" style="display:inline-block;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من الحذف؟')">حذف</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="4" class="text-muted">لا توجد مناطق حتى الآن</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/areas/all_area.blade.php ENDPATH**/ ?>