

<?php $__env->startSection('title', 'نتائج تجديد التراخيص'); ?>

<?php $__env->startSection('content'); ?>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نتيجة تتبع الطلب</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        :root {
            --dark-blue: #0d2b50;
            --gold: #d4af37;
        }
        
        .card {
            border: 3px solid var(--gold);
            border-radius: 0;
            position: relative;
        }
        
        .card::before,
        .card::after {
            content: '';
            position: absolute;
            width: 20px;
            height: 20px;
            border: 2px solid var(--gold);
        }
        
        .card::before {
            top: -2px;
            left: -2px;
            border-right: none;
            border-bottom: none;
        }
        
        .card::after {
            bottom: -2px;
            right: -2px;
            border-left: none;
            border-top: none;
        }
        
        .card-header {
            background: var(--dark-blue);
            border-bottom: 3px solid var(--gold);
        }
        
        .table thead th {
            background: var(--dark-blue);
            color: var(--gold);
            border: 1px solid var(--gold);
        }
        
        .table tbody td {
            border: 1px solid rgba(212, 175, 55, 0.2);
        }
        
        .btn-outline-success {
            border-color: var(--dark-blue);
            color: var(--dark-blue);
        }
    </style>
<div class="container mt-4">
    <h2 class="mb-4">نتائج تجديد التراخيص</h2>

    <table class="table table-bordered table-striped">
        <thead class="table-primary">
            <tr>
                <th>اسم المدرسة</th>
                <th>اسم الفرع</th>
                <th>المديرية</th>
                <th>الحالة</th>
                <th>الملاحظات</th>
                <th>ملف الموافقة</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $renewals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $renewal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($renewal->school ? $renewal->school->school_name : '-'); ?></td>
                    <td><?php echo e($renewal->branch_name); ?></td>
                    <td><?php echo e($renewal->area ? $renewal->area->name : '-'); ?></td>
                    <td>
                       <?php if( $renewal ): ?>

                        <?php switch($renewal->status):
                                                    case ('قيد المراجعة'): ?>
                                                        <span class="badge bg-secondary"><i class="fas fa-clock me-1"></i> قيد المراجعة</span>
                                                        <?php break; ?>
                                                    <?php case ('مقبول'): ?>
                                                        <span class="badge bg-success p-2"><i class="fas fa-check-circle me-1"></i> مقبول</span>
                                                        <?php break; ?>
                                                    <?php case ('مرفوض'): ?>
                                                        <span class="badge bg-danger p-2"><i class="fas fa-times-circle me-1"></i> مرفوض</span>
                                                        <?php break; ?>
                                                    <?php default: ?>
                                                        <span class="badge bg-secondary p-2">-</span>
                                                <?php endswitch; ?>
                                            <?php else: ?>
                                                <span class="badge bg-secondary p-2">لا يوجد </span>
                                            <?php endif; ?>
                                        </td>
                    
                    <td><?php echo e($renewal->notes ?? '-'); ?></td>
                    <td>
                        <?php if($renewal->status === 'مقبول' && $renewal->admin_document): ?>
                        <span class="badge bg-success p-2"><i class="fas fa-check-circle me-1"></i>
                            <a href="<?php echo e(asset('storage/' . $renewal->admin_document)); ?>" target="_blank" class="btn btn-sm btn-success">عرض الملف</a>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center">لا توجد نتائج حالياً</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('client.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/client/result.blade.php ENDPATH**/ ?>