

<?php $__env->startSection('content'); ?>

<div class="card p-4">

    <h2 class="mb-4">تعديل بيانات المدرسة</h2>

    <form action="<?php echo e(route('schools.update', $school->id)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="mb-3">
            <label for="school_name" class="form-label">اسم المدرسة:</label>
            <input type="text" name="school_name" id="school_name" class="form-control" required value="<?php echo e(old('school_name', $school->school_name)); ?>">
        </div>

        <div class="mb-3">
            <label class="form-label">نوع المدرسة:</label><br>
            <?php
                $selectedTypes = json_decode($school->type, true) ?? [];
            ?>


  <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="type[]" id="pteparatory" value="pteparatory" <?php echo e(in_array('pteparatory', $selectedTypes) ? 'checked' : ''); ?>>
                <label class="form-check-label" for="primary">تمهيدي</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="type[]" id="primary" value="primary" <?php echo e(in_array('primary', $selectedTypes) ? 'checked' : ''); ?>>
                <label class="form-check-label" for="primary">أساسي</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="type[]" id="middle" value="middle" <?php echo e(in_array('middle', $selectedTypes) ? 'checked' : ''); ?>>
                <label class="form-check-label" for="middle">إعدادي</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="type[]" id="high" value="high" <?php echo e(in_array('high', $selectedTypes) ? 'checked' : ''); ?>>
                <label class="form-check-label" for="high">ثانوي</label>
            </div>
        </div>

        <div class="mb-3">
            <label for="logo" class="form-label">شعار المدرسة (اختياري):</label>
            <input type="file" name="logo" id="logo" class="form-control">
            <?php if($school->logo): ?>
                <div class="mt-2">
                    <img src="<?php echo e(asset('storage/' . $school->logo)); ?>" alt="الشعار الحالي" width="100" height="100">
                </div>
            <?php endif; ?>
        </div>

        <div class="mb-3">
            <label for="city_id" class="form-label">اختر المحافظة:</label>
            <select name="city_id" id="city_id" class="form-select" required>
                <option value="">اختر المحافظة</option>
                <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($city->id); ?>" <?php echo e(old('city_id', $school->city_id) == $city->id ? 'selected' : ''); ?>><?php echo e($city->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="user_id" class="form-label">اختر المستخدم المسؤول:</label>
            <select name="user_id" id="user_id" class="form-select" required>
                <option value="">اختر المستخدم</option>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($user->id); ?>" <?php echo e(old('user_id', $school->user_id) == $user->id ? 'selected' : ''); ?>><?php echo e($user->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <button type="submit" class="btn btn-primary">تحديث</button>

    </form>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/school/edit_school.blade.php ENDPATH**/ ?>