



<?php $__env->startSection('title', 'تفاصيل طلب تجديد الترخيص'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?php echo e(session('success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <div class="card border-0 shadow-lg">
        <div class="card-header bg-primary text-white py-3">
            <div class="d-flex justify-content-between align-items-center">
                <h3 class="mb-0">
                    <i class="fas fa-file-contract me-2"></i>تفاصيل طلب تجديد الترخيص <?php echo e($renwel->id); ?>

                </h3>
                <span class="badge bg-light text-dark fs-5">
                    <?php echo e($renwel->status ?? 'قيد المراجعة'); ?>

                </span>
            </div>
        </div>

        <div class="card-body">
            <!-- بيانات المدرسة -->
            <div class="section-header mb-4 mt-3">
                <h5 class="text-primary border-bottom border-primary pb-2 d-inline-block">
                    <i class="fas fa-school me-2"></i>بيانات المدرسة
                </h5>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-4 mb-3">
                    <div class="info-item bg-light p-3 rounded border">
                        <strong class="d-block text-muted mb-1">اسم المدرسة</strong>
                        <span><?php echo e($renwel->school->school_name ?? '-'); ?></span>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="info-item bg-light p-3 rounded border">
                        <strong class="d-block text-muted mb-1">الفرع</strong>
                        <span><?php echo e($renwel->branch_name ?? '-'); ?></span>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="info-item bg-light p-3 rounded border">
                        <strong class="d-block text-muted mb-1">المديرية</strong>
                        <span><?php echo e($renwel->area?->name ?? '-'); ?></span>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="info-item bg-light p-3 rounded border">
                        <strong class="d-block text-muted mb-1">الأقسام</strong>
                        <span><?php echo e(implode('، ', json_decode($renwel->sections ?? '[]')) ?: '-'); ?></span>
                    </div>
                </div>
            </div>

            <!-- ملفات الوثائق -->
            <div class="section-header mb-4">
                <h5 class="text-info border-bottom border-info pb-2 d-inline-block">
                    <i class="fas fa-file-alt me-2"></i>الوثائق المرفقة
                </h5>
            </div>
            
            <div class="row g-3 mb-4">
                <?php $__currentLoopData = [
                    'teachers_documents' => ' وثائق المعلمين الاشقاء والغير اشقاء',
                    'renewal_form' => 'استمارة طلب تجديد الترخيص',
                    'certificate_purchase_receipt' => 'سند شراء الشهادات',
                    'occupancy_receipt' => 'سند الأشغال',
                    'stage_addition_receipt' => 'سند إضافة مرحلة',
                    'community_contribution_receipt' => 'سند المساهمة المجتمعية',
                    'civil_defense_receipt' => 'سند الدفاع المدني',
                    'book_purchase_receipt' => 'سند شراء الكتب',
                    'rental_contract_image' => 'عقد الإيجار',
                    'violations' => 'المخالفات',
                    'capacity' => 'الطاقة الاستيعابية'
                ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($renwel->$field): ?>
                <div class="col-md-4">
                    <div class="document-item border rounded p-3 h-100">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <strong class="text-dark"><?php echo e($label); ?></strong>
                            <a href="<?php echo e(asset('storage/' . $renwel->$field)); ?>" target="_blank" 
                               class="btn btn-sm btn-outline-info py-1 px-2">
                                <i class="fas fa-eye me-1"></i>عرض
                            </a>
                        </div>
                        <div class="text-truncate small text-muted">
                            <!-- <?php echo e(basename($renwel->$field)); ?> -->
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- ملفات الإحصائيات -->
            <div class="section-header mb-4">
                <h5 class="text-secondary border-bottom border-secondary pb-2 d-inline-block">
                    <i class="fas fa-chart-line me-2"></i>ملفات الإحصائيات
                </h5>
            </div>
            
            <div class="row g-3 mb-4">
                <?php $__currentLoopData = [
                    'students_count' => 'عدد الطلاب',
                    'classes_count' => ' بيانات متعلقةباحتياجات المدرسة ',
                    'teachers_count' => 'عدد المعلمين',
                    'pass_count' => 'نسبة النجاح والرسوب',
                    'fail_count' => 'نسبة الغياب',
                    'curriculums_count' => 'المناهج',
                    'class_hours' => 'التعهدات',
                    'workforce_count' => 'القوى العاملة'
                ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($renwel->$field): ?>
                <div class="col-md-4">
                    <div class="document-item border rounded p-3 h-100">
                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <strong class="text-dark">إحصائية <?php echo e($label); ?></strong>
                            <a href="<?php echo e(asset('storage/' . $renwel->$field)); ?>" target="_blank" 
                               class="btn btn-sm btn-outline-secondary py-1 px-2">
                                <i class="fas fa-eye me-1"></i>عرض
                            </a>
                        </div>
                        <div class="text-truncate small text-muted">
                            <!-- <?php echo e(basename($renwel->$field)); ?> -->
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- ملف موافقة الادمن -->
            <div class="section-header mb-4">
                <h5 class="text-success border-bottom border-success pb-2 d-inline-block">
                    <i class="fas fa-check-circle me-2"></i>ملف موافقة الإدارة
                </h5>
            </div>
            
            <div class="mb-5">
                <?php if($renwel->admin_document): ?>
                <div class="d-flex align-items-center bg-light-success p-3 rounded border border-success">
                    <i class="fas fa-file-pdf fs-3 text-success me-3"></i>
                    <div class="flex-grow-1">
                        <div class="fw-bold">ملف الموافقة الرسمي</div>
                        <div class="text-truncate small text-muted w-75">
                            <!-- <?php echo e(basename($renwel->admin_document)); ?> -->
                        </div>
                    </div>
                        <a href="<?php echo e(asset('storage/' . $renwel->admin_document)); ?>"  target="_blank" 
                       class="btn btn-success py-2 px-4">
                        <i class="fas fa-download me-2"></i>تحميل الموافقة
                    </a>
                </div>
                <?php else: ?>
                <div class="alert alert-warning bg-light-warning border-warning">
                    <i class="fas fa-exclamation-circle me-2"></i>لم يتم رفع ملف الموافقة بعد
                </div>
                <?php endif; ?>
            </div>

            <!-- نموذج تحديث الحالة والملاحظات -->
            <div class="section-header mb-4">
                <h5 class="text-dark border-bottom border-dark pb-2 d-inline-block">
                    <i class="fas fa-edit me-2"></i>تقييم الطلب
                </h5>
            </div>
            
            <form method="POST" action="<?php echo e(route('admin.renwels.update', $renwel->id)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                
                <div class="row g-4">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="notes" class="form-label fw-bold">ملاحظات المشرف:</label>
                            <textarea name="notes" id="notes" rows="4" 
                                      class="form-control border-primary <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                      placeholder="أدخل ملاحظاتك هنا..."><?php echo e(old('notes', $renwel->notes)); ?></textarea>
                            <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="form-group mb-4">
                            <label for="status" class="form-label fw-bold">الحالة النهائية:</label>
                            <select name="status" id="status" 
                                    class="form-select border-primary <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <!-- <option value="">-- اختر الحالة --</option> -->
                                <option value="قيد المراجعة" <?php echo e(old('status', $renwel->status) == 'قيد المراجعة' ? 'selected' : ''); ?>>قيد المراجعة</option>
                                <option value="مقبول" <?php echo e(old('status', $renwel->status) == 'مقبول' ? 'selected' : ''); ?>>مقبول</option>
                                <option value="مرفوض" <?php echo e(old('status', $renwel->status) == 'مرفوض' ? 'selected' : ''); ?>>مرفوض</option>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="form-group">
                            <label for="approval_file" class="form-label fw-bold">رفع ملف الموافقة:</label>
                            <div class="input-group">
                                <input type="file" name="admin_document" id="admin_document" 
                                       class="form-control border-primary <?php $__errorArgs = ['admin_document'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       accept=".pdf,.jpg,.jpeg,.png">
                                <button class="btn btn-outline-primary" type="button">
                                    <i class="fas fa-upload"></i>
                                </button>
                            </div>
                            <div class="form-text">صيغ الملفات المسموحة: PDF, JPG, JPEG, PNG (الحجم الأقصى: 5MB)</div>
                            <?php $__errorArgs = ['admin_document'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>
                
                <div class="d-flex justify-content-between align-items-center mt-5 pt-3 border-top">
                    <div>
                        <?php if($previous): ?>
                        <a href="<?php echo e(route('admin.renwels.index', $previous->id)); ?>" 
                           class="btn btn-outline-primary py-2 px-4">
                            <i class="fas fa-arrow-right me-2"></i>السابق
                        </a>
                        <?php endif; ?>
                    </div>




                    
                    <button type="submit" class="btn btn-primary py-2 px-5">
                        <i class="fas fa-save me-2"></i>حفظ التحديثات
                    </button>
                    
               
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<style>
    .section-header {
        position: relative;
        padding-bottom: 10px;
    }
    
    .info-item {
        transition: all 0.3s ease;
    }
    
    .info-item:hover {
        background-color: #f8f9fa !important;
        transform: translateY(-2px);
    }
    
    .document-item {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        background-color: #fafafa;
    }
    
    .document-item:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }
</style>

<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/license_renewal/show.blade.php ENDPATH**/ ?>