


<?php $__env->startSection('content'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --primary-blue: #1a365d;
            --secondary-blue: #2c5282;
            --gold: #d4af37;
            --light-gray: #f5f7fa;
            --dark-gray: #4a5568;
            --white: #ffffff;
            
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            --transition: all 0.3s ease;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f0f2f5;
            color: #333;
            min-height: 100vh;
            padding: 20px;
            background-image: linear-gradient(to bottom, #f0f2f5, #e6e9ed);
        }
        
        .dashboard-container {
            max-width: 1400px;
            margin: 0 auto;
        }
        
        .govt-header {
            background: linear-gradient(to right, var(--primary-blue), var(--secondary-blue));
            color: var(--white);
            padding: 25px 40px;
            border-radius: 10px;
            margin-bottom: 30px;
            box-shadow: var(--shadow);
            border-bottom: 5px solid var(--gold);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .govt-header-content {
            flex: 1;
        }
        
        .govt-logo {
            width: 100px;
            height: 100px;
            background-color: var(--white);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-left: 20px;
            border: 3px solid var(--gold);
        }
        
        .govt-logo i {
            font-size: 50px;
            color: var(--primary-blue);
        }
        
        .govt-header h1 {
            font-size: 2.2rem;
            font-weight: 700;
            margin-bottom: 10px;
            letter-spacing: 0.5px;
        }
        
        .govt-header p {
            font-size: 1.1rem;
            opacity: 0.9;
            max-width: 700px;
        }
        
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 25px;
            padding: 10px;
        }
        
        .govt-card {
            background: var(--white);
            border-radius: 12px;
            padding: 25px;
            color: var(--primary-blue);
            box-shadow: var(--shadow);
            transition: var(--transition);
            min-height: 200px;
            position: relative;
            overflow: hidden;
            border-top: 4px solid var(--gold);
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        
        .govt-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }
        
        .govt-card-icon {
            position: absolute;
            top: 20px;
            left: 20px;
            width: 60px;
            height: 60px;
            background: rgba(26, 54, 93, 0.1);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .govt-card-icon i {
            font-size: 28px;
            color: var(--primary-blue);
        }
        
        .govt-card-content {
            text-align: right;
            padding-left: 70px;
        }
        
        .govt-card-title {
            font-size: 1.25rem;
            font-weight: 700;
            margin-bottom: 8px;
            color: var(--primary-blue);
        }
        
        .govt-card-count {
            font-size: 2.2rem;
            font-weight: 800;
            margin: 10px 0;
            color: var(--secondary-blue);
        }
        
        .govt-card-link {
            display: inline-block;
            margin-top: 15px;
            padding: 8px 15px;
            background: var(--primary-blue);
            color: var(--white);
            border-radius: 6px;
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
            border: 1px solid var(--primary-blue);
            font-size: 0.95rem;
        }
        
        .govt-card-link:hover {
            background: transparent;
            color: var(--primary-blue);
            border: 1px solid var(--primary-blue);
        }
        
        .govt-footer {
            text-align: center;
            margin-top: 40px;
            padding: 20px;
            color: var(--dark-gray);
            font-size: 0.9rem;
            border-top: 1px solid #e2e8f0;
        }
        
        .timestamp {
            background: var(--white);
            padding: 15px;
            border-radius: 8px;
            display: inline-block;
            margin-top: 10px;
            box-shadow: var(--shadow);
            font-weight: 600;
            color: var(--secondary-blue);
            border: 1px solid #e2e8f0;
        }
        
        /* Responsive design */
        @media (max-width: 768px) {
            .dashboard-grid {
                grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            }
            
            .govt-header {
                flex-direction: column;
                text-align: center;
            }
            
            .govt-logo {
                margin: 15px auto;
            }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <!-- رأس الصفحة -->
        <header class="govt-header">
            <div class="govt-header-content">
                <h1>وزارة التربية والتعليم</h1>
                <p>لوحة التحكم الإدارية - نظام إدارة المؤسسات التعليمية</p>
            </div>
            <div class="govt-logo">
                <i class="bi bi-building"></i>
            </div>
        </header>
        
        <!-- بطاقات الإحصائيات -->
        <div class="dashboard-grid">
            <!-- المستخدمين -->
            <div class="govt-card">
                <div class="govt-card-icon">
                    <i class="bi bi-people"></i>
                </div>
                <div class="govt-card-content">
                    <div class="govt-card-title">المستخدمين</div>
                    <div class="govt-card-count"><?php echo e($usersCount); ?></div>
                    <a href="<?php echo e(route('users.index')); ?>" class="govt-card-link">عرض التفاصيل</a>
                </div>
            </div>
            
            <!-- المحافظات -->
            <div class="govt-card">
                <div class="govt-card-icon">
                    <i class="bi bi-globe"></i>
                </div>
                <div class="govt-card-content">
                    <div class="govt-card-title">المحافظات</div>
                    <div class="govt-card-count"><?php echo e($citiesCount); ?></div>
                    <a href="<?php echo e(route('cities.index')); ?>" class="govt-card-link">عرض التفاصيل</a>
                </div>
            </div>
            
            <!-- طلبات الترخيص -->
            <div class="govt-card">
                <div class="govt-card-icon">
                    <i class="bi bi-file-earmark-text"></i>
                </div>
                <div class="govt-card-content">
                    <div class="govt-card-title">طلبات الترخيص</div>
                    <div class="govt-card-count"><?php echo e($licensesCount); ?></div>
                    <a href="<?php echo e(route('licenses.index')); ?>" class="govt-card-link">عرض التفاصيل</a>
                </div>
            </div>
            
            <!-- الفروع -->
            <div class="govt-card">
                <div class="govt-card-icon">
                    <i class="bi bi-diagram-3"></i>
                </div>
                <div class="govt-card-content">
                    <div class="govt-card-title">فروع المدارس</div>
                    <div class="govt-card-count"><?php echo e($branchesCount); ?></div>
                    <a href="<?php echo e(route('branches.index')); ?>" class="govt-card-link">عرض التفاصيل</a>
                </div>
            </div>
            
            <!-- المدارس -->
            <div class="govt-card">
                <div class="govt-card-icon">
                    <i class="bi bi-building"></i>
                </div>
                <div class="govt-card-content">
                    <div class="govt-card-title">المدارس</div>
                    <div class="govt-card-count"><?php echo e($SchoolsCount); ?></div>
                    <a href="<?php echo e(route('schools.index')); ?>" class="govt-card-link">عرض التفاصيل</a>
                </div>
            </div>
            
            <!-- المناطق التعليمية -->
            <div class="govt-card">
                <div class="govt-card-icon">
                    <i class="bi bi-map"></i>
                </div>
                <div class="govt-card-content">
                    <div class="govt-card-title">المناطق التعليمية</div>
                    <div class="govt-card-count"><?php echo e($areasCount); ?></div>
                    <a href="<?php echo e(route('areas.index')); ?>" class="govt-card-link">عرض التفاصيل</a>
                </div>
            </div>
            
            <!-- الصلاحيات -->
            <div class="govt-card">
                <div class="govt-card-icon">
                    <i class="bi bi-shield-lock"></i>
                </div>
                <div class="govt-card-content">
                    <div class="govt-card-title">الصلاحيات</div>
                    <div class="govt-card-count">-</div>
                    <a href="<?php echo e(route('users.withRoles')); ?>" class="govt-card-link">عرض التفاصيل</a>
                </div>
            </div>
            

   <div class="govt-card">
                <div class="govt-card-icon">
                    <i class="bi bi-shield-lock"></i>
                </div>
                <div class="govt-card-content">
                    <div class="govt-card-title">تجديد التراخيص</div>
                    <div class="govt-card-count"><?php echo e($RenewalCount); ?></div>
                    <a href="<?php echo e(route('admin.renwels.index')); ?>" class="govt-card-link">عرض التفاصيل</a>
                </div>
            </div>





            <!-- التقارير -->
            <!-- <div class="govt-card">
                <div class="govt-card-icon">
                    <i class="bi bi-clipboard-data"></i>
                </div>
                <div class="govt-card-content">
                    <div class="govt-card-title">التقارير الإحصائية</div>
                    <div class="govt-card-count">48</div>
                    <a href="#" class="govt-card-link">عرض التفاصيل</a>
                </div>
            </div> -->
        </div>
        
        <!-- تذييل الصفحة -->
        <footer class="govt-footer">
            <p>جميع الحقوق محفوظة © وزارة التربية والتعليم 2025</p>
           
         
        </footer>
    </div>

 
</body>
</html>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/admin/user/main_menus.blade.php ENDPATH**/ ?>