

<?php $__env->startSection('title', 'تم إرسال الطلب بنجاح'); ?>

<?php $__env->startSection('content'); ?>
    <style>
        body {
            background-color: #f4f6f9;
        }

        .success-container {
            min-height: 80vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .success-card {
            background: #ffffff;
            padding: 40px;
            border-radius: 20px;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
            text-align: center;
            max-width: 600px;
            width: 100%;
        }

        .success-icon {
            font-size: 90px;
            color: #198754;
            animation: pop 0.4s ease-in-out;
        }

        @keyframes pop {
            0% {
                transform: scale(0.5);
                opacity: 0;
            }
            100% {
                transform: scale(1);
                opacity: 1;
            }
        }

        .btn-main {
            background-color: #198754;
            color: white;
            border: none;
            padding: 10px 30px;
            font-size: 18px;
            border-radius: 8px;
            margin-top: 20px;
            transition: background-color 0.3s ease;
        }

        .btn-main:hover {
            background-color: #157347;
        }

        .countdown {
            font-weight: bold;
            font-size: 16px;
            margin-top: 15px;
            color: #555;
        }
    </style>

    <div class="success-container">
        <div class="success-card">
            <div class="success-icon mb-4">
                <i class="bi bi-check-circle-fill"></i>
            </div>
            <h2 class="text-success fw-bold mb-3">تم إرسال الطلب بنجاح</h2>
            <p class="lead mb-2">شكرًا لك! تم استلام طلب ترخيص المدرسة وسيتم مراجعته من قبل المختصين.</p>
            <p class="text-muted">سيتم تحويلك تلقائيًا إلى لوحة التحكم بعد <span id="counter">10</span> ثوانٍ.</p>
              <br>
              <br>
            <a href="<?php echo e(route('client.dashboard')); ?>" class="btn btn-main">العودة الآن</a>

            <div class="countdown" id="countdown"></div>
        </div>
    </div>

    <!-- صوت إشعار النجاح -->
    <audio id="successSound" autoplay>
        <source src="https://cdn.pixabay.com/download/audio/2021/08/04/audio_c7d0137ac9.mp3?filename=success-1-6297.mp3" type="audio/mpeg">
        متصفحك لا يدعم تشغيل الصوت.
    </audio>

    <script>
        // تشغيل صوت النجاح عند تحميل الصفحة
        window.addEventListener('load', function () {
            const sound = document.getElementById('successSound');
            sound.play().catch(e => {
                // في حال لم يتم السماح تلقائيًا، يمكن المستخدم يشغله يدويًا
                console.warn('الصوت لم يُشغّل تلقائيًا بسبب إعدادات المتصفح.');
            });
        });

    //     // العداد التنازلي
        let count = 10;
        const counterEl = document.getElementById('counter');

        const interval = setInterval(() => {
            count--;
            counterEl.textContent = count;

            if (count <= 0) {
                clearInterval(interval);
                window.location.href = "<?php echo e(route('client.dashboard')); ?>";
            }
        }, 1000);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('client.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\king6\schoolsystem\resources\views/client/license_success.blade.php ENDPATH**/ ?>