<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>شروط ترخيص المدارس - وزارة التعليم</title>
  <link href="https://fonts.googleapis.com/css2?family=Noto+Naskh+Arabic:wght@400;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }
    
    body {
      font-family: 'Noto Naskh Arabic', serif;
      background: linear-gradient(135deg, #f5fbff, #e6f2ff);
      color: #333;
      padding: 20px;
      min-height: 100vh;
      line-height: 1.6;
    }
    
    .header {
      text-align: center;
      padding: 25px;
      margin-bottom: 20px;
      background: linear-gradient(to right, #1a3a8f, #2a5caa);
      border-radius: 15px;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
      color: white;
      position: relative;
      overflow: hidden;
      border: 1px solid #0d2a6e;
    }
    
    .header::before {
      content: "";
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 5px;
      background: linear-gradient(to right, #ffcc00, #ff9900);
    }
    
    .header h1 {
      font-size: 32px;
      margin-bottom: 10px;
      font-weight: 700;
      text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
    }
    
    .header p {
      font-size: 18px;
      opacity: 0.9;
    }
    
    .logo {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 15px;
      margin-bottom: 15px;
    }
    
    .logo-icon {
      width: 70px;
      height: 70px;
      background: white;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #1a3a8f;
      font-size: 32px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
      border: 3px solid #ffcc00;
    }
    
    .container {
      max-width: 1000px;
      margin: 0 auto;
    }
    
    .important-notice {
      background: linear-gradient(to right, #fff8e1, #fff3c9);
      border: 2px solid #ffcc00;
      border-radius: 15px;
      padding: 25px;
      margin: 0 auto 30px;
      position: relative;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }
    
    .important-notice h3 {
      color: #d35400;
      font-size: 26px;
      margin-bottom: 15px;
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .important-notice p {
      font-size: 18px;
      margin-bottom: 15px;
      line-height: 1.8;
    }
    
    .notice-icon {
      position: absolute;
      top: -20px;
      left: 20px;
      background: #ffcc00;
      color: #1a3a8f;
      width: 60px;
      height: 60px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 28px;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.15);
      border: 3px solid white;
    }
    
    .card {
      background: white;
      border-radius: 15px;
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
      margin-bottom: 30px;
      padding: 30px;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
      border: 1px solid #e0e8ff;
      position: relative;
      overflow: hidden;
    }
    
    .card::before {
      content: "";
      position: absolute;
      top: 0;
      right: 0;
      width: 8px;
      height: 100%;
      background: linear-gradient(to bottom, #1a3a8f, #2a5caa);
    }
    
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 12px 30px rgba(0, 0, 0, 0.15);
    }
    
    h2 {
      margin-top: 0;
      font-size: 24px;
      color: #1a3a8f;
      margin-bottom: 20px;
      padding-bottom: 10px;
      border-bottom: 2px solid #e0e8ff;
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    h2 i {
      color: #ffcc00;
      background: #1a3a8f;
      width: 40px;
      height: 40px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    
    ul {
      padding-right: 10px;
      list-style: none;
    }
    
    li {
      margin-bottom: 15px;
      font-size: 18px;
      padding: 15px;
      border-radius: 10px;
      background-color: #f8fbff;
      display: flex;
      align-items: flex-start;
      gap: 15px;
      transition: all 0.3s ease;
      border: 1px solid #e0e8ff;
    }
    
    li:hover {
      background-color: #eef5ff;
      transform: translateX(-5px);
    }
    
    .checkbox-container {
      display: flex;
      align-items: center;
      gap: 15px;
      width: 100%;
    }
    
    .custom-checkbox {
      position: relative;
      width: 26px;
      height: 26px;
      flex-shrink: 0;
    }
    
    .custom-checkbox input {
      position: absolute;
      opacity: 0;
      cursor: pointer;
      width: 100%;
      height: 100%;
      z-index: 2;
    }
    
    .checkmark {
      position: absolute;
      top: 0;
      right: 0;
      height: 26px;
      width: 26px;
      background-color: #fff;
      border: 2px solid #1a3a8f;
      border-radius: 5px;
      transition: all 0.3s ease;
    }
    
    .custom-checkbox input:checked ~ .checkmark {
      background-color: #1a3a8f;
      border-color: #1a3a8f;
    }
    
    .checkmark:after {
      content: "";
      position: absolute;
      display: none;
    }
    
    .custom-checkbox input:checked ~ .checkmark:after {
      display: block;
    }
    
    .custom-checkbox .checkmark:after {
      right: 8px;
      top: 4px;
      width: 8px;
      height: 14px;
      border: solid white;
      border-width: 0 3px 3px 0;
      transform: rotate(45deg);
    }
    
    .buttons-container {
      display: flex;
      justify-content: center;
      gap: 20px;
      margin: 40px 0 20px;
      flex-wrap: wrap;
    }
    
    .agree-button {
      padding: 16px 40px;
      background: linear-gradient(to right, #1a3a8f, #2a5caa);
      color: white;
      border: none;
      border-radius: 10px;
      font-size: 20px;
      cursor: pointer;
      transition: all 0.3s ease;
      font-family: 'Noto Naskh Arabic', serif;
      font-weight: 600;
      box-shadow: 0 5px 15px rgba(26, 58, 143, 0.3);
      display: flex;
      align-items: center;
      gap: 15px;
      min-width: 280px;
      justify-content: center;
    }
    
    .agree-button:hover {
      background: linear-gradient(to right, #15307a, #214a94);
      transform: translateY(-3px);
      box-shadow: 0 8px 20px rgba(26, 58, 143, 0.4);
    }
    
    .agree-button:disabled {
      background: #cccccc;
      cursor: not-allowed;
      transform: none;
      box-shadow: none;
    }
    
    .start-button {
      padding: 16px 40px;
      background: linear-gradient(to right, #008751, #00a86b);
      color: white;
      border: none;
      border-radius: 10px;
      font-size: 20px;
      cursor: pointer;
      transition: all 0.3s ease;
      font-family: 'Noto Naskh Arabic', serif;
      font-weight: 600;
      box-shadow: 0 5px 15px rgba(0, 135, 81, 0.3);
      display: flex;
      align-items: center;
      gap: 15px;
      min-width: 280px;
      justify-content: center;
    }
    
    .start-button:hover {
      background: linear-gradient(to right, #007245, #00925d);
      transform: translateY(-3px);
      box-shadow: 0 8px 20px rgba(0, 135, 81, 0.4);
    }
    
    .start-button:disabled {
      background: #cccccc;
      cursor: not-allowed;
      transform: none;
      box-shadow: none;
    }
    
    .footer {
      text-align: center;
      padding: 25px;
      margin-top: 30px;
      background: #f8fbff;
      border-radius: 15px;
      color: #1a3a8f;
      font-size: 16px;
      border: 1px solid #e0e8ff;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
    }
    
    .progress-container {
      margin: 25px 0;
      background: #eef5ff;
      border-radius: 50px;
      height: 12px;
      overflow: hidden;
      border: 1px solid #d0dfff;
    }
    
    .progress-bar {
      height: 100%;
      background: linear-gradient(to right, #1a3a8f, #2a5caa);
      width: 0%;
      transition: width 0.5s ease;
      border-radius: 50px;
    }
    
    .progress-text {
      text-align: center;
      font-size: 18px;
      color: #1a3a8f;
      margin-top: 10px;
      font-weight: 600;
    }
    
    .required-note {
      text-align: center;
      color: #e74c3c;
      font-weight: bold;
      margin: 15px 0;
      font-size: 18px;
      background: #ffeded;
      padding: 10px;
      border-radius: 8px;
      border: 1px solid #ffcccc;
    }
    
    .section-counter {
      background: #1a3a8f;
      color: white;
      padding: 5px 12px;
      border-radius: 20px;
      font-size: 18px;
      margin-left: 10px;
    }
    
    @media (max-width: 768px) {
      .card {
        padding: 20px;
      }
      
      h2 {
        font-size: 20px;
      }
      
      li {
        font-size: 16px;
        padding: 12px;
      }
      
      .agree-button, .start-button {
        padding: 14px 20px;
        font-size: 18px;
        min-width: 240px;
      }
      
      .header h1 {
        font-size: 26px;
      }
      
      .important-notice {
        padding: 20px 15px;
      }
      
      .important-notice h3 {
        font-size: 22px;
      }
    }
    
    @media (max-width: 480px) {
      .buttons-container {
        flex-direction: column;
        align-items: center;
      }
      
      .header h1 {
        font-size: 22px;
      }
      
      .header p {
        font-size: 16px;
      }
      
      .logo-icon {
        width: 50px;
        height: 50px;
        font-size: 24px;
      }
      
      .important-notice {
        padding: 25px 15px 15px;
      }
      
      .notice-icon {
        top: -15px;
        left: 10px;
        width: 40px;
        height: 40px;
        font-size: 20px;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">
      
      <div class="logo">
        <div class="logo-icon">
          <i class="fas fa-school"></i>
        </div>
        <div>
          
          <h1>شروط ترخيص المدارس</h1>
          <p>وزارة التربية والتعليم - الجمهورية اليمنية</p>
        </div>
      </div>
    </div>
    
    <!-- إضافة قسم التنبيه الهام -->
    <div class="important-notice">
      <div class="notice-icon">
        <i class="fas fa-exclamation-triangle"></i>
      </div>
      <h3><i class="fas fa-info-circle"></i> تنبيه هام</h3>
      <p>تعتبر الشروط المذكورة في هذه الصفحة <strong>ضرورية وأساسية</strong> للحصول على ترخيص تشغيل المدرسة.</p>
      <p>يجب على جميع المؤسسات التعليمية الراغبة في الحصول على ترخيص الالتزام بهذه الشروط <strong>بشكل كامل</strong> قبل تقديم الطلب.</p>
      <p>سيتم بعد تقديم الطلب إرسال <strong>لجنة متخصصة</strong> من وزارة التعليم لمعاينة المبنى والتأكد من استيفاء جميع الشروط المطلوبة.</p>
      <p>يرجى العلم أن عدم الالتزام بأي من هذه الشروط سوف يؤدي إلى <strong>رفض الطلب</strong> أو تأخير إصدار الترخيص حتى يتم استكمال النواقص.</p>
    </div>
    
    <div class="required-note">
      <i class="fas fa-exclamation-circle"></i> يجب الموافقة على جميع الشروط قبل المتابعة
    </div>
    
    <div class="progress-container">
      <div class="progress-bar" id="progressBar"></div>
    </div>
    <div class="progress-text" id="progressText">0% من الشروط موافق عليها</div>

    <div class="card">
      <h2><i class="fas fa-ban"></i> أولًا: الموانع الكلية لاستخدام المبنى <span class="section-counter">4 بنود</span></h2>
      <ul>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>موقع المدرسة في منطقة غير آمنة أو معرضة للكوارث الطبيعية</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>قرب المدرسة من مصادر إزعاج شديد (مصانع، أسواق مزدحمة... إلخ)</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>مبنى غير مرخص أو مخالف لشروط البناء</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>وجود عوائق إنشائية تمنع التهوية أو الإضاءة الطبيعية</span>
          </div>
        </li>
      </ul>
    </div>

    <div class="card">
      <h2><i class="fas fa-exclamation-triangle"></i> ثانيًا: الموانع الجزئية <span class="section-counter">4 بنود</span></h2>
      <ul>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>نقص عدد المرافق الصحية المطلوبة</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>عدم توفر مخرج طوارئ</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>مساحات الصفوف غير كافية لكل طالب</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>نقص في اشتراطات السلامة مثل طفايات الحريق والإنذارات</span>
          </div>
        </li>
      </ul>
    </div>

    <div class="card">
      <h2><i class="fas fa-clipboard-list"></i> ثالثًا: المعايير العامة والخاصة <span class="section-counter">4 بنود</span></h2>
      <ul>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>أن يكون المبنى مستقلًا وغير مشترك مع أنشطة أخرى</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>توفر ساحات مناسبة للطلاب</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>تخصيص غرف للأنشطة، والإدارة، والمعلمين</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>توفير سبل وصول لذوي الاحتياجات الخاصة</span>
          </div>
        </li>
      </ul>
    </div>

    <div class="card">
      <h2><i class="fas fa-building"></i> رابعًا: معايير موقع المدرسة والشكل الداخلي <span class="section-counter">4 بنود</span></h2>
      <ul>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>أن تكون قريبة من المناطق السكنية</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>توفر مواقف سيارات كافية</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>تصميم داخلي آمن ومرن وقابل للتوسع</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>أن تكون الفصول بعيدة عن مصادر الإزعاج الداخلي (مثل غرفة المولد أو المطبخ)</span>
          </div>
        </li>
      </ul>
    </div>

    <div class="card">
      <h2><i class="fas fa-ruler-combined"></i> خامسًا: الشروط الفنية لمساحات الغرف <span class="section-counter">4 بنود</span></h2>
      <ul>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>الصف الدراسي: لا يقل عن 45 متر مربع للصف الواحد</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>الإدارة والمعلمين: تخصيص غرفة مستقلة لا تقل عن 12 متر مربع</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>غرف الأنشطة: بمساحة لا تقل عن 20 متر مربع لكل نشاط</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>دورات المياه: بمعدل دورة واحدة لكل 25 طالبًا</span>
          </div>
        </li>
      </ul>
    </div>

    <div class="card">
      <h2><i class="fas fa-shield-alt"></i> سادسًا: شروط الأمن والسلامة <span class="section-counter">4 بنود</span></h2>
      <ul>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>وجود مخارج طوارئ واضحة وسهلة الوصول</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>تركيب كاشفات دخان في جميع المناطق</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>وجود خطة إخلاء وتدريب الطلاب عليها</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>طفايات حريق موزعة على كل الأدوار ومداخل المدرسة</span>
          </div>
        </li>
      </ul>
    </div>

    <div class="card">
      <h2><i class="fas fa-file-alt"></i> سابعًا: المستندات المطلوبة <span class="section-counter">4 بنود</span></h2>
      <ul>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>طلب رسمي لترخيص المدرسة</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>صورة من عقد الملكية أو الإيجار للمبنى</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>مخططات هندسية معتمدة</span>
          </div>
        </li>
        <li>
          <div class="checkbox-container">
            <label class="custom-checkbox">
              <input type="checkbox" class="condition-checkbox">
              <span class="checkmark"></span>
            </label>
            <span>سجل السلامة والصحة للمبنى</span>
          </div>
        </li>
      </ul>
    </div>

    <div class="buttons-container">
      <button id="agreeBtn" class="agree-button" disabled>
        <i class="fas fa-check-circle"></i> موافق على الشروط
      </button>
      <button id="startBtn" class="start-button" disabled>
        <i class="fas fa-file-contract"></i> ابدأ الترخيص الآن
      </button>
    </div>

    <div class="footer">
      <p>    وزارة التربية التعليم -الجمهورية اليمنية 2025</p>
      <p>للاستفسار: 7777777 | البريد الإلكتروني: yemen@edu.gov.sa</p>
      <p>ساعات العمل: السبت - الخميس من 8:00 صباحًا إلى 4:00 مساءً</p>
    </div>
  </div>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const checkboxes = document.querySelectorAll('.condition-checkbox');
      const agreeBtn = document.getElementById('agreeBtn');
      const startBtn = document.getElementById('startBtn');
      const progressBar = document.getElementById('progressBar');
      const progressText = document.getElementById('progressText');
      const totalConditions = checkboxes.length;
      
      // تحديث حالة الأزرار وشريط التقدم
      function updateConditions() {
        const checkedCount = document.querySelectorAll('.condition-checkbox:checked').length;
        const percentage = Math.round((checkedCount / totalConditions) * 100);
        
        // تحديث شريط التقدم
        progressBar.style.width = `${percentage}%`;
        progressText.textContent = `${percentage}% من الشروط موافق عليها`;
        
        // تفعيل زر الموافقة إذا تم اختيار جميع الشروط
        agreeBtn.disabled = checkedCount !== totalConditions;
      }
      
      // إضافة مستمع الحدث لكل مربع اختيار
      checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', updateConditions);
      });
      
      // عند النقر على زر الموافقة
      agreeBtn.addEventListener('click', function() {
        // تعطيل جميع مربعات الاختيار
        checkboxes.forEach(checkbox => {
          checkbox.disabled = true;
        });
        
        // تفعيل زر البدء
        startBtn.disabled = false;
        
        // تغيير مظهر زر الموافقة
        agreeBtn.innerHTML = '<i class="fas fa-check-circle"></i> تمت الموافقة على جميع الشروط';
        agreeBtn.style.background = 'linear-gradient(to right, #008751, #00a86b)';
        agreeBtn.disabled = true;
        
        // إظهار رسالة تأكيد
        alert('تمت الموافقة على جميع الشروط بنجاح. يمكنك الآن بدء عملية الترخيص.');
      });
      
      // عند النقر على زر البدء
      startBtn.addEventListener('click', function() {
        // إنشاء تأثير تحميل
        startBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> جارٍ التوجيه...';
        startBtn.disabled = true;
        
        // محاكاة الانتقال إلى صفحة أخرى بعد تأخير
        setTimeout(function() {
          // هنا يمكنك تغيير الرابط إلى صفحة الطلب الفعلية
          window.location.href = "<?php echo e(route('client.license.step1')); ?>";
        }, 1500);
      });
    });
  </script>
</body>
</html>
<?php /**PATH C:\Users\king6\schoolsystem\resources\views/client/laws.blade.php ENDPATH**/ ?>