<?php

use App\Http\Controllers\AdminAuthController;
use App\Http\Controllers\AdminLicenseController;
use App\Http\Controllers\AreaController;
use App\Http\Controllers\AuthRegisterController;
use App\Http\Controllers\BrancheController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\Client\ClientSchoolController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\ClientDashboardController;
use App\Http\Controllers\ClientLicenseController;
use App\Http\Controllers\ClientSchoolController as ControllersClientSchoolController;
use App\Http\Controllers\CommitteeDashboardController;
use App\Http\Controllers\CommitteLicenseController;
use App\Http\Controllers\LicenseController;
use App\Http\Controllers\LicenseRenewalController;
use App\Http\Controllers\RenewalController;
use App\Http\Controllers\RenewalTrackingControllerController;
use App\Http\Controllers\RenewLicenseAdminController;
use App\Http\Controllers\RenewLicenseCommitteController;
use App\Http\Controllers\RenewLicenseController;
use App\Http\Controllers\SchoolBranchController;
use App\Http\Controllers\SchoolController;
use App\Http\Controllers\UserController;
use App\Mail\LicenseStatusUpdated;
use App\Mail\RenewalStatusUpdated;
use App\Models\License;
use App\Models\licenseRenwel;
use App\Models\Renwel;
use App\Models\School;
use GuzzleHttp\Client;
use GuzzleHttp\Middleware;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Response;
use Symfony\Component\HttpKernel\DependencyInjection\RegisterControllerArgumentLocatorsPass;
Auth::routes();

Route::get('/', function () {
    return view('client.welcome');
});

// لوحات التحكم
Route::resource('/cities', CityController::class)->middleware(['auth','role:super_admin']);
// Route::resource('/users', UserController::class);
Route::resource('users', UserController::class)->except(['show'])->middleware(['auth','role:super_admin']);
Route::resource('/schools', SchoolController::class)->middleware(['auth','role:super_admin']);
Route::resource('/areas', AreaController::class)->middleware(['auth','role:super_admin']);
Route::resource('/branches', BrancheController::class)->middleware(['auth','role:super_admin']);
Route::resource('/licenses', LicenseController::class)->middleware(['auth','role:super_admin']);

// صفحة لوحة التحكم الرئيسية (بعد الدخول)
Route::get('/main-menus', function () {
    return view('admin.user.main_menus');
})->name('admin.main_menus')
 ->middleware(['auth','role:super_admin']);
//  Route::resource('/licens', Renwel::class);
// صفحة تسجيل الدخول
Route::get('/show-login', [AdminAuthController::class, 'showLogin'])->name('login');

// تنفيذ تسجيل الدخول
Route::post('/do-login', [AdminAuthController::class, 'login'])->name('admin.login');

// إنشاء مستخدم سوبر أدمن (للاستخدام التجريبي فقط)
Route::get('/add-user', [AdminAuthController::class, 'register']);

Route::post('/logout', [AdminAuthController::class, 'logout'])->name('logout');

Route::get('/contact', function () {
    return view('admin.contact');
})->name('contact');



//تبع اللجان


Route::get('/committee-dashboard', function () {
    return view('committee.dashboard');
})->name('committee.dashboard')->middleware(['auth', 'role:committee_member']);

// حق البحث واظخار الصفحات الاخرى الادوار
Route::get('/users/search', [UserController::class, 'liveSearch'])->name('users.liveSearch');
Route::get('/assign-role/{id}', [UserController::class, 'showAssignRoleForm'])->name('users.assignRoleForm');
Route::post('/assign-role/{id}', [UserController::class, 'assignRole'])->name('users.assignRole');

Route::get('/users/roles', [UserController::class, 'usersWithRoles'])->name('users.roles')->middleware(['auth','role:super_admin']);




// صفحة عرض جميع المستخدمين مع أدوارهم
Route::get('/users-with-roles', [UserController::class, 'usersWithRoles'])->name('users.withRoles');


Route::get('/users/live-search', [UserController::class, 'liveSearch'])->name('users.liveSearch');




//من هنا بدأت
Route::get('/committee/dashboard', [CommitteeDashboardController::class, 'dashboard'])->name('committee.dashboard');

Route::prefix('committee')->name('committee.')->group(function () {
    Route::resource('licenses', CommitteLicenseController::class)
->middleware(['auth', 'role:committee_member']);

});




Route::get('/committee/licenses/status/{status}', 
[CommitteLicenseController::class, 'statusFilter'])->name('committee.licenses.status');


Route::post('/committee/logout',
 [CommitteeDashboardController::class, 'logout'])->name('committee.logout');

Route::get('/committee/licenses/{id}/add', 
[CommitteLicenseController::class, 'add'])->name('committee.licenses.add');


//تبع التعديل حق التراخيص
Route::post('/committee/licenses/{id}/update-status', 
[CommitteLicenseController::class, 'updateStatus'])->name('committee.licenses.updateStatus');





//تبع تسجيل الدخول حق المستخدمين

Route::get('register', [AuthRegisterController::class, 'showRegistrationForm'])->name('register');
Route::post('register', [AuthRegisterController::class, 'register']);


Route::middleware(['auth'])->group(function () {
    Route::get('/client/dashboard', [AuthRegisterController::class, 'dashboard'])->name('client.dashboard');
});



// //تبع المستخدم حق البحث
// Route::get('/users/search', [UserController::class, 'liveSearch'])->name('users.liveSearch');


// welcomeتبع صقحة الترحيبيه حق المستخدم  
Route::get('/dashboard', [ClientDashboardController::class, 'index'])->name('client.dashboard');


// file_uploade صفحة تحميل ملفات الpdf

Route::get('/file/uploade', [ClientDashboardController::class, 'show'])->name('license_terms');

Route::get('/law', [ClientDashboardController::class, 'all'])->name('law');




Route::prefix('client')->middleware(['auth'])->name('client.')->group(function () {
    // عرض النموذج
    Route::get('/license/step1', [ClientController::class, 'create'])->name('license.step1');
    // حفظ البيانات
    Route::post('/license/step1', [ClientController::class, 'store'])->name('license.step1');
        Route::get('/license/step2{school}', [ClientController::class, 'step2'])->name('client.license.step2');
});


//العودة الى الشاشة الرئيسيه
Route::get('/client/home', function () {
    return view('client.welcome');
})->middleware('auth')->name('client.home');


// عشان انتقل الصفحة الثانية من التراخيص حق الفروع

Route::prefix('client')->name('client.')->middleware('auth')->group(function () {
    // عرض نموذج step2 لإدخال بيانات الفرع
    Route::get('/license/step2/{school}', [SchoolBranchController::class, 'step2'])->name('license.step2');
    // حفظ بيانات step2
    Route::post('/license/step2/{school}', [SchoolBranchController::class, 'storeStep2'])->name('license.step2.store');

});


//عشان ينتقل لصفحة الثالثه license_step3
Route::get('/license/success', function () {
    return view('client.license_success');
})->name('license.success');


// تبع الصفحة حق الترخيص  الملاحظات
Route::middleware('auth')->group(function () {
    Route::get('/track-request', [ClientLicenseController::class, 'trackResult'])->name('client.track.result');
});


//عشان مربع التعديل اللي في الفروع ينقلني الى  تعديل الترخيص   
Route::get('/branches-with-licenses', [BrancheController::class, 'indexWithLicenses'])->name('branches.with.licenses');




//  عند الادمن تبع التعديل حق التراخيص
Route::post('/admin/licenses/{id}/update-status', 
[AdminLicenseController::class, 'updateStatus'])->name('admin.licenses.updateStatus');
Route::put('/licenses/{id}', 
[AdminLicenseController::class, 'update'])->name('licenses.update');
Route::get('/admin/licenses/{id}/add', 
[AdminLicenseController::class, 'add'])->name('admin.licenses.add');
Route::get('/admin/licenses/status/{status}', 
[AdminLicenseController::class, 'statusFilter'])->name('admin.licenses.status');
//عشان مربع التعديل اللي في الفروع ينقلني الى  تعديل الترخيص   





//عشان عرض المحافظات
Route::get('/committee/licenses/city/{city}', [CommitteeDashboardController::class, 'showByCity'])->name('committee.licenses.byCity');
Route::prefix('committee')->middleware(['auth'])->group(function () {
    Route::get('/licenses', [CommitteeDashboardController::class, 'allLicenses'])->name('committee.licenses.index');
    Route::get('/licenses/{id}', [CommitteeDashboardController::class, 'show'])->name('committee.licenses.show');
});



// صقحة القوانين قبل البدء

 

    

     Route::get('/client/law', [ClientDashboardController::class, 'showlaw'])->middleware('auth')->name('client.low');
    // Route::get('/content', [ClientDashboardController::class, 'content'])->middleware('auth')->name('client.content');


///////////////////////////////////////

// // مسارات المصادقة
// Route::get('/login', [AdminAuthController::class, 'showLoginForm'])->name('login');
// Route::post('/login', [AdminAuthController::class, 'login']);
// Route::post('/logout', [AdminAuthController::class, 'logout'])->name('logout');


// صفحة الاتصال المحمية
Route::get('/content', [ClientDashboardController::class, 'content'])->name('client.content');

// مسارات محمية (اختيارية)
Route::middleware(['auth'])->group(function () {
    Route::get('/client/law', [ClientDashboardController::class, 'showlaw'])->name('client.law');
    Route::get('/client/dashboard', [ClientDashboardController::class, 'dashboard'])->name('client.dashboard');
});



Route::get('/logout', [ClientDashboardController::class, 'logout'])->name('logout');

//تبع الpdf يتم رفعة للمستخدم
Route::get('/client/branches/status', [ClientLicenseController::class, 'showBranchStatus'])
    ->middleware('auth')
    ->name('client.branch.status');
Route::get('/client/school-branches', [ClientDashboardController::class, 'showUserBranches'])->name('client.branches')->middleware('auth');




Route::post('/licenses/{id}/update', [LicenseController::class, 'update'])->name('licenses.update');


/////////////////////////////email

Route::post('/committee/licenses/{id}/update-status', [CommitteLicenseController::class, 'update'])
    ->name('committee.licenses.updateStatus');
/////////////////////////////////////////////////// عشان اجرب طلب الترخيص
// http://localhost:8000/test-email/11
Route::get('/test-email-licenses/{id}', function ($id) {
    $license = License::with('branch.school','user')->findOrFail($id);
    return new LicenseStatusUpdated($license);
});



/////renewal
Route::put('/committee/renwels/{id}', [RenewalTrackingControllerController::class, 'update'])
    ->name('committee.renwels.update');
Route::get('/test-email-renewal/{id}', function ($id) {
    $renewal = Renwel::with('user', 'school', 'branch')->findOrFail($id);
    Mail::to($renewal->user->email)->send(new RenewalStatusUpdated($renewal));
    return "تم إرسال البريد الإلكتروني لتجديد الترخيص رقم {$id} إلى: " . $renewal->user->email;
});

/////عشان اختبره
Route::get('/test-email-renewal/{id}', function ($id) {
    $renewal = Renwel::with('user', 'school', 'area')->findOrFail($id);
    return new RenewalStatusUpdated($renewal);
});





///////////////////////////////////////////////////



// تبع الدمن تجديد التراخيص 

// تبع المستخدم تجديد التراخيص 



// تجديد التراخيص
// Route::prefix('renew')->group(function () {
    Route::get('/renewlas', [RenewLicenseController::class, 'create'])->middleware('auth')->name('renew.create');
    Route::post('/renewals', [RenewLicenseController::class, 'store'])->middleware('auth')->name('renew.store');
    Route::get('/success', [RenewLicenseController::class, 'success'])->name('renew.success');


// });

    
    // إرسال الطلب النهائي
    // Route::post('/submit', [RenewLicenseController::class, 'submitRenewal'])->name('submit');
    
    // // صفحة الإكمال
    // Route::get('/complete', [RenewLicenseController::class, 'complete'])->name('complete');
    
    // // APIs
    // Route::get('/get-branches/{school}', [RenewLicenseController::class, 'getBranches'])->name('getBranches');
    // Route::get('/get-branch-area/{branch}', [RenewLicenseController::class, 'getBranchArea'])->name('getBranchArea');



// الملفات حق الترخيص

Route::get('/download-teacher-report', function () {
    $filePath = public_path('files/كشف_المعلمين.docx'); 
    $fileName = 'كشف_المعلمين_' . date('Ymd') . '.docx'; // اسم الملف عند التحميل مع التاريخ

    if (!file_exists($filePath)) {
        abort(404, 'الملف غير موجود');}
    return Response::download($filePath, $fileName);
})->name('download.teacher.report');


Route::get('/download-renewal-report', function () {
    $filePath = public_path('files/renewal.docx'); 
    $fileas = 'renewal' . date('Ymd') . '.docx'; // اسم الملف عند التحميل مع التاريخ
    if (!file_exists($filePath)) {
        abort(404, 'الملف غير موجود'); }
    return Response::download($filePath, $fileas);
})->name('download.renewal');



Route::get('/download-student-report', function () {
    $filePath = public_path('files/استمارات_التجديد_الطلاب_المتوقع_تسجيلهم.docx'); 
    $fileName = 'استمارات_التجديد_الطلاب_المتوقع_تسجيلهم' . date('Ymd') . '.docx'; // اسم الملف عند التحميل مع التاريخ

    if (!file_exists($filePath)) {
        abort(404, 'الملف غير موجود');}
    return Response::download($filePath, $fileName);
})->name('download.student.report');

// بيانات_متعلقة_باحتياجات_المدرسة
Route::get('/student-report', function () {
    $filePath = public_path('files/بيانات_متعلقة_باحتياجات_المدرسة.docx'); 
    $fileName = 'بيانات_متعلقة_باحتياجات_المدرسة' . date('Ymd') . '.docx'; // اسم الملف عند التحميل مع التاريخ

    if (!file_exists($filePath)) {
        abort(404, 'الملف غير موجود');}
    return Response::download($filePath, $fileName);
})->name('student.report');

Route::get('/school', function () {
    $filePath = public_path('files/التعهدات.docx'); 
    $fileName = 'التعهدات' . date('Ymd') . '.docx'; // اسم الملف عند التحميل مع التاريخ

    if (!file_exists($filePath)) {
        abort(404, 'الملف غير موجود');}
    return Response::download($filePath, $fileName);
})->name('school');

Route::get('/bank', function () {
    $filePath = public_path('files/كاك_بنك.docx'); 
    $fileName = 'كاك_بنك' . date('Ymd') . '.docx'; // اسم الملف عند التحميل مع التاريخ

    if (!file_exists($filePath)) {
        abort(404, 'الملف غير موجود');}
    return Response::download($filePath, $fileName);
})->name('bank');






// التجديد عند admin


    Route::get('/admin/renwels', [RenewLicenseAdminController::class, 'index'])->name('admin.renwels.index')->middleware(['auth','role:super_admin']);
    Route::get('/renwels/{id}', [RenewLicenseAdminController::class, 'show'])->name('admin.renwels.show')->middleware(['auth','role:super_admin']);
    Route::put('/renwels/{id}/status', [RenewLicenseAdminController::class, 'update'])->name('admin.renwels.update')->middleware(['auth','role:super_admin']);
Route::delete('/admin/renwels/{id}', [RenewLicenseAdminController::class, 'destroy'])->name('admin.renwels.destroy');
    // بعد التجديد يرجع الى الصفحة الرئيسة
// Route::get('/home', function () {
//     return view('client.renew.step4');
// })->middleware('auth')->name('home');




// التجديد عند committe


    Route::get('/committee/renwelss', [RenewLicenseCommitteController::class, 'index'])->name('committee.renwels.index');
    Route::get('/committee/renwelss/{id}', [RenewLicenseCommitteController::class, 'show'])->name('committee.show');
    Route::put('/committee/renwelss/{id}/status', [RenewLicenseCommitteController::class, 'update'])->name('committee.renwels.update');
   Route::delete('/committee/renwels/{id}', [RenewLicenseCommitteController::class, 'destroy'])->name('committee.renwels.destroy');



    //صفحة noschool
    Route::middleware(['auth'])->group(function () {
    Route::get('/schools/create', [RenewLicenseController::class, 'add'])->name('schools.create');
    Route::post('/schools', [RenewLicenseController::class, 'all'])->name('schools.store');
});

//عشان يعرض حالات التتبع عند 
Route::get('/tracking', [RenewalTrackingControllerController::class, 'index'])->middleware('auth')->name('tracking.index');


// عشان يعر1 مربعات المخافظات تبع اللجان لتجديد
Route::get('/committee/dashboard/renewal', [CommitteeDashboardController::class, 'renewalByCity'])->name('committee.city');
Route::get('/committee/renewals/city/{cityId}', [CommitteeDashboardController::class, 'showCity'])->name('committee.city.byCity');



