@extends('committee.layout.master')

@section('content')

<div class="flex justify-between items-center mb-6">
    <h2 class="text-2xl font-bold text-gray-800">قائمة التراخيص</h2>
    <a href="{{ route('committee.licenses.index') }}"
       class="bg-gray-100 hover:bg-gray-200 text-gray-700 text-sm px-4 py-2 rounded-md shadow">
      <br>  ← الرجوع لكل التراخيص
        <br>
    </a>
    <br>
</div>

<div class="overflow-x-auto bg-white rounded-xl shadow p-4">
    <table class="min-w-full text-sm text-right text-gray-700">
        <thead class="bg-gray-50 border-b text-gray-600">
            <tr>
                <th class="py-3 px-4">الرقم</th>
                <th class="py-3 px-4">اسم المدرسة</th>
                <th class="py-3 px-4">الفرع</th>
                <th class="py-3 px-4">الحالة</th>
                <th class="py-3 px-4">تاريخ التقديم</th>
                <th class="py-3 px-4"> عرض التفاصيل</th>
            </tr>
        </thead>
        <tbody>
            @forelse($licenses as $license)
                <tr class="border-b hover:bg-gray-50">
                    <td class="py-3 px-4">{{ $license->id }}</td>
                    <td class="py-3 px-4">{{ $license->branch->school->school_name ?? '—' }}</td>
                    <td class="py-3 px-4">{{ $license->branch->name ?? '—' }}</td>
                    <td class="py-3 px-4">
                        @switch($license->status)
                            @case('under_review')
                                <span class="inline-block px-2 py-1 text-xs bg-yellow-100 text-yellow-800 rounded-full">قيد المراجعة</span>
                                @break
                            @case('approved')
                                <span class="inline-block px-2 py-1 text-xs bg-green-100 text-green-800 rounded-full">موافق عليه</span>
                                @break
                            @case('rejected')
                                <span class="inline-block px-2 py-1 text-xs bg-red-100 text-red-800 rounded-full">مرفوض</span>
                                @break
                            @default
                                <span class="inline-block px-2 py-1 text-xs bg-gray-100 text-gray-500 rounded-full">غير معروف</span>
                        @endswitch
                    </td>
                    <td class="py-3 px-4">{{ $license->created_at->format('Y-m-d') }}</td>
                    <td class="py-3 px-4 text-center">
                      <a href="{{ route('committee.licenses.add', $license->id) }}" class="btn btn-sm btn-info">التفاصيل</a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="text-center py-6 text-gray-500">لا توجد تراخيص حالياً</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

@endsection
