@extends('committee.layout.master')

@section('content')
<div class="container mt-4">
    <h2 class="mb-4">طلبات تجديد التراخيص لمحافظة {{ $city->name }}</h2>

    @if($renewals->count() > 0)
    <table class="table table-bordered table-striped text-right" dir="rtl">
 
            <table class="table table-bordered align-middle text-center">
                <thead class="table-light">
                    <tr>
                        <th>الرقم</th>
                        <th>اسم المدرسة</th>
                        <th>الفرع</th>
                        <th>المديرية</th>
                        <th>الحالة</th>
                        <th>خيارات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($renewals as $index => $renwel)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $renwel->school->school_name ?? '-' }}</td> <!-- إظهار اسم المدرسة -->
                      <td>{{ $renwel->branch_name ?? '-' }}</td> <!-- إظهار الفرع كاسم -->
                     <td>{{ $renwel->area->name ?? '-' }}</td>
                            <td>
                                @switch($renwel->status)
                                    @case('مقبول')
                                        <span class="badge bg-success">مقبول</span>
                                        @break
                                    @case('مرفوض')
                                        <span class="badge bg-danger">مرفوض</span>
                                        @break
                                    @default
                                        <span class="badge bg-warning text-dark">قيد المراجعة</span>
                                @endswitch
                            </td>
                            <td>
                                <a href="{{ route('committee.show', $renwel->id) }}" class="btn btn-sm btn-primary">
                                    <i class="fas fa-eye"></i> عرض
                                </a>
                            </td>
                        </tr>
                    @endforeach
        </tbody>
    </table>
    @else
    <p>لا توجد طلبات تجديد في هذه المحافظة.</p>
    @endif
</div>
@endsection
