<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>بوابة المدارس الأهلية - وزارة التربية والتعليم</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #003366;
            --secondary-color: #f5b041;
            --accent-color: #004080;
            --light-color: #f9f9f9;
            --text-dark: #333;
            --text-light: #f8f9fa;
            --shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            --transition: all 0.3s ease;
            --gold: #d4af37;
            --light-blue: #e6f2ff;
            --dark-blue: #001a33;
            --header-height: 120px;
        }
        
        body {
            font-family: 'Cairo', sans-serif;
            background-color: var(--light-color);
            color: var(--text-dark);
            padding-top: 0;
            background: linear-gradient(135deg, #f0f7ff, #ffffff);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        /* رأس الصفحة - تصميم حكومي راقي */
        header {
            background: linear-gradient(to left, var(--primary-color), var(--dark-blue));
            color: var(--text-light);
            padding: 15px 0;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 1000;
            border-bottom: 4px solid var(--gold);
        }
        
        .header-title {
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            padding: 10px 0;
        }
        
        .header-title img {
            height: 80px;
            margin-left: 20px;
            filter: drop-shadow(0 0 4px rgba(255, 255, 255, 0.5));
            background: white;
            padding: 5px;
            border-radius: 8px;
            border: 2px solid var(--gold);
        }
        
        .header-title h4 {
            font-weight: 700;
            margin-bottom: 0;
            text-shadow: 0 1px 3px rgba(0, 0, 0, 0.3);
            font-size: 2rem;
            color: white;
            letter-spacing: 0.5px;
        }
        
        .ministry-name {
            position: absolute;
            bottom: -15px;
            right: 0;
            background: var(--gold);
            color: var(--primary-color);
            padding: 7px 25px;
            border-radius: 30px;
            font-weight: 700;
            font-size: 1.2rem;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
            border: 2px solid white;
        }
        
        /* قائمة التنقل - تصميم حكومي متطور */
        .main-nav {
            background: white;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
            position: sticky;
            top: var(--header-height);
            z-index: 999;
            border-bottom: 2px solid var(--light-blue);
        }
        
        .nav-container {
            display: flex;
            justify-content: space-around;
            padding: 0;
            flex-wrap: wrap;
        }
        
        .nav-link {
            color: var(--primary-color) !important;
            font-weight: 600;
            font-size: 17px;
            padding: 18px 25px;
            transition: var(--transition);
            position: relative;
            display: flex;
            align-items: center;
            text-align: center;
            border-radius: 5px;
            margin: 5px;
        }
        
        .nav-link i {
            margin-left: 10px;
            font-size: 20px;
            color: var(--accent-color);
        }
        
        .nav-link:hover {
            color: var(--secondary-color) !important;
            background: rgba(245, 176, 65, 0.05);
            transform: translateY(-3px);
        }
        
        .nav-link:hover::after {
            content: '';
            position: absolute;
            bottom: 0;
            right: 0;
            left: 0;
            height: 3px;
            background: var(--secondary-color);
            border-radius: 3px;
        }
        
        .nav-link.active {
            background: var(--light-blue);
            color: var(--primary-color) !important;
            box-shadow: 0 3px 8px rgba(0, 0, 0, 0.1);
        }
        
        .nav-link.active i {
            color: var(--gold);
        }
        
        /* قسم البطاقات - تصميم متطور مع صورة مركزية */
        .hero-section {
            background: linear-gradient(to left, rgba(0, 64, 128, 0.9), rgba(0, 102, 204, 0.9));
            color: white;
            padding: 100px 20px 120px;
            text-align: center;
            margin-bottom: 50px;
            position: relative;
            overflow: hidden;
            background-image: url('https://images.unsplash.com/photo-1541339907198-e08756dedf3f?q=80&w=2070');
            background-size: cover;
            background-position: center;
            background-blend-mode: multiply;
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 70vh;
        }
        
        .hero-content {
            position: relative;
            z-index: 2;
            max-width: 900px;
            margin: 0 auto;
            padding: 40px;
            background: rgba(0, 51, 102, 0.7);
            border-radius: 20px;
            backdrop-filter: blur(5px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.3);
        }
        
        .hero-section h2 {
            font-size: 3.2rem;
            font-weight: 800;
            margin-bottom: 25px;
            position: relative;
            text-shadow: 0 2px 8px rgba(0, 0, 0, 0.3);
            color: white;
        }
        
        .hero-section p {
            font-size: 1.5rem;
            margin: 0 auto 30px;
            opacity: 0.95;
            position: relative;
            line-height: 1.8;
            max-width: 800px;
        }
        
        .hero-buttons {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-top: 30px;
            flex-wrap: wrap;
        }
        
        .btn-hero {
            padding: 12px 35px;
            font-size: 1.2rem;
            font-weight: 600;
            border-radius: 50px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease;
            border: none;
            min-width: 220px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .btn-hero-primary {
            background: linear-gradient(to left, var(--gold), #e6b224);
            color: var(--primary-color);
        }
        
        .btn-hero-secondary {
            background: linear-gradient(to left, var(--primary-color), var(--accent-color));
            color: white;
        }
        
        .btn-hero:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.3);
        }
        
        .cards-section {
            padding: 40px 0 70px;
            background: #f8fbff;
            position: relative;
            margin-top: -80px;
            border-radius: 30px 30px 0 0;
            box-shadow: 0 -10px 30px rgba(0, 0, 0, 0.05);
            z-index: 10;
        }
        
        .section-title {
            text-align: center;
            margin-bottom: 50px;
            position: relative;
            padding-top: 30px;
        }
        
        .section-title h3 {
            color: var(--primary-color);
            font-weight: 800;
            font-size: 2.5rem;
            margin-bottom: 15px;
            position: relative;
            display: inline-block;
        }
        
        .section-title h3::after {
            content: '';
            position: absolute;
            bottom: -10px;
            right: 50%;
            transform: translateX(50%);
            width: 80px;
            height: 4px;
            background: var(--gold);
            border-radius: 2px;
        }
        
        .section-title p {
            color: var(--accent-color);
            font-size: 1.2rem;
            max-width: 700px;
            margin: 0 auto;
        }
        
        .stat-card {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: var(--shadow);
            transition: var(--transition);
            height: 100%;
            position: relative;
            border: none;
            margin-bottom: 25px;
        }
        
        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 5px;
            background: var(--gold);
            transition: var(--transition);
        }
        
        .stat-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.15);
        }
        
        .stat-card:hover::before {
            background: var(--primary-color);
        }
        
        .card-icon {
            font-size: 3.5rem;
            margin: 25px 0 15px;
            color: var(--primary-color);
            transition: var(--transition);
        }
        
        .stat-card:hover .card-icon {
            color: var(--gold);
            transform: scale(1.1);
        }
        
        .stat-card h5 {
            font-weight: 700;
            margin-bottom: 20px;
            color: var(--primary-color);
            font-size: 1.5rem;
            padding: 0 20px;
        }
        
        .stat-card .btn {
            border-radius: 30px;
            padding: 10px 25px;
            font-weight: 600;
            margin: 15px 0 30px;
            transition: var(--transition);
            background: linear-gradient(to right, var(--primary-color), var(--accent-color));
            border: none;
            color: white;
            box-shadow: 0 4px 10px rgba(0, 51, 102, 0.2);
        }
        
        .stat-card .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(0, 51, 102, 0.3);
            background: linear-gradient(to right, var(--accent-color), var(--primary-color));
        }
        
        .stat-number {
            font-size: 2.5rem;
            font-weight: 800;
            display: block;
            margin: 20px 0;
            color: var(--primary-color);
        }
        
        .text-accent {
            color: var(--gold) !important;
        }
        
        /* محتوى الصفحة */
        .main-content {
            padding: 60px 0;
            background: white;
        }
        
        .features-section {
            padding: 80px 0;
            background: #f0f7ff;
        }
        
        .feature-card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: var(--shadow);
            transition: var(--transition);
            height: 100%;
            text-align: center;
            border-top: 4px solid var(--gold);
        }
        
        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }
        
        .feature-icon {
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 20px;
            transition: var(--transition);
        }
        
        .feature-card:hover .feature-icon {
            color: var(--gold);
            transform: scale(1.1);
        }
        
        .feature-card h4 {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 15px;
        }
        
        /* تذييل الصفحة - تصميم حكومي */
        footer {
            background: linear-gradient(to left, var(--primary-color), var(--dark-blue));
            color: rgba(255, 255, 255, 0.85);
            text-align: center;
            padding: 50px 0 30px;
            margin-top: auto;
            font-size: 16px;
            border-top: 4px solid var(--gold);
        }
        
        .footer-logo {
            width: 120px;
            height: auto;
            margin-bottom: 20px;
            filter: drop-shadow(0 0 5px rgba(255, 255, 255, 0.3));
        }
        
        .footer-title {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 10px;
            color: white;
        }
        
        .footer-subtitle {
            font-size: 1.2rem;
            margin-bottom: 30px;
            color: var(--gold);
        }
        
        .footer-links {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 20px;
            margin: 30px 0;
        }
        
        .footer-links a {
            color: var(--gold);
            text-decoration: none;
            transition: var(--transition);
            font-weight: 600;
            padding: 8px 15px;
            border-radius: 5px;
        }
        
        .footer-links a:hover {
            color: white;
            background: rgba(255, 255, 255, 0.1);
            transform: translateY(-3px);
        }
        
        .social-links {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin: 25px 0;
        }
        
        .social-icon {
            width: 45px;
            height: 45px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.1);
            color: white;
            border-radius: 50%;
            font-size: 1.2rem;
            transition: var(--transition);
        }
        
        .social-icon:hover {
            background: var(--gold);
            color: var(--primary-color);
            transform: translateY(-5px);
        }
        
        .copyright {
            padding-top: 25px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            margin-top: 30px;
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.7);
        }
        
        /* تأثيرات للجوال */
        @media (max-width: 992px) {
            .header-title h4 {
                font-size: 1.6rem;
            }
            
            .hero-section h2 {
                font-size: 2.5rem;
            }
            
            .hero-section p {
                font-size: 1.2rem;
            }
            
            .btn-hero {
                padding: 10px 25px;
                font-size: 1rem;
                min-width: 180px;
            }
            
            .nav-link {
                padding: 12px 15px;
                font-size: 15px;
            }
        }
        
        @media (max-width: 768px) {
            .header-title {
                flex-direction: column;
                text-align: center;
            }
            
            .header-title img {
                margin-left: 0;
                margin-bottom: 10px;
                height: 70px;
            }
            
            .ministry-name {
                position: static;
                margin-top: 10px;
                display: inline-block;
            }
            
            .hero-content {
                padding: 25px;
            }
            
            .hero-section h2 {
                font-size: 2rem;
            }
            
            .hero-section p {
                font-size: 1.1rem;
            }
            
            .hero-buttons {
                flex-direction: column;
                gap: 15px;
            }
            
            .nav-container {
                flex-direction: column;
                align-items: center;
            }
            
            .nav-link {
                width: 100%;
                justify-content: center;
                border-bottom: 1px solid #eee;
                padding: 15px;
            }
        }
    </style>
</head>
<body>

<!-- رأس الصفحة -->
<header>
            <!-- @auth
        <div class="alert alert-success">
            أنت مسجل دخول كـ {{ Auth::user()->name }}
        </div>
        @endauth -->
    <div class="container">
        <div class="header-title">
            <img src="{{ asset('img.jpg') }}" alt="شعار الهيئة">
            <h4 class="mb-0">الهيئة العامة للمدارس الأهلية</h4>
            
            <span class="ministry-name">وزارة التربية والتعليم</span>
        </div>
    </div>
</header>

<!-- قائمة التنقل -->
<nav class="main-nav">
    <div class="container">
        <div class="nav-container">
            <a class="nav-link active" href="{{ route('client.home') }}">
                <i class="fas fa-home"></i> الرئيسية
            </a>
            <a class="nav-link" href="{{ route('client.law') }}">
                <i class="fas fa-file-alt"></i> طلب ترخيص
            </a>
             <a class="nav-link" href="{{route('renew.create')}}">
                <i class="fas fa-gavel"></i>  تجديد الترخيص 
            </a>
            <a href="{{ route('license_terms') }}" class="nav-link">
                <i class="fas fa-file-download"></i> تحميل الشروط
            </a>
        
            <a class="nav-link" href="{{ route('client.content') }}">
                <i class="fas fa-headset"></i> التواصل بنا
            </a>
          <form action="{{ route('logout') }}" method="POST" class="d-inline">
    @csrf
    <button type="submit" class="nav-link btn btn-link" style="border: none; background: none; cursor: pointer;">
        <i class="fas fa-sign-out-alt"></i> خروج
    </button>
</form>

        </div>
    </div>
</nav>
<main>
    @yield('content')
<!-- قسم البطاقات مع صورة مركزية -->
 @include('client.dashboard') {{-- القائمة الجانبية --}}
<!-- محتوى الصفحة الداخلية -->
<main class="main-content">
    <div class="container">
        <div class="alert alert-primary text-center">
            <h4><i class="fas fa-info-circle me-2"></i> مرحبا بكم في البوابة الإلكترونية للمدارس الأهلية</h4>
            <p class="mb-0">نظام متكامل لإدارة طلبات الترخيص والتجديد لمؤسسات التعليم الأهلي</p>
        </div>
    </div>
</main>

<!-- تذييل -->
<footer>
    <div class="container">
        <img src="{{ asset('img.jpg') }}" alt="الشعار" class="footer-logo">
        <div class="footer-title">الهيئة العامة للمدارس الأهلية</div>
        <div class="footer-subtitle">وزارة التربية والتعليم - الجمهورية اليمنية</div>
        
        <div class="footer-links">
            <a href="{{ route('client.home') }}"><i class="fas fa-home me-2"></i> الرئيسية</a>
            <a href="#"><i class="fas fa-info-circle me-2"></i> عن الهيئة</a>
            <a href="{{ route('license_terms') }}"><i class="fas fa-file-alt me-2"></i> الشروط والأحكام</a>
            <a href="#"><i class="fas fa-headset me-2"></i> الدعم الفني</a>
            <a href="#"><i class="fas fa-question-circle me-2"></i> الأسئلة الشائعة</a>
        </div>
        
        <div class="social-links">
            <a href="#" class="social-icon"><i class="fab fa-facebook-f"></i></a>
            <a href="#" class="social-icon"><i class="fab fa-twitter"></i></a>
            <a href="#" class="social-icon"><i class="fab fa-instagram"></i></a>
            <a href="#" class="social-icon"><i class="fab fa-youtube"></i></a>
        </div>
        
        <div class="copyright">
            جميع الحقوق محفوظة © الهيئة العامة للمدارس الأهلية - <span id="currentYear"></span>
        </div>
    </div>
</footer>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // إضافة السنة الحالية في التذييل
    document.getElementById('currentYear').textContent = new Date().getFullYear();
    
    // تأثير التمرير السلس
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            document.querySelector(this.getAttribute('href')).scrollIntoView({
                behavior: 'smooth'
            });
        });
    });
</script>
</body>
</html>
