<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>موقع تراخيص</title>
  <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
</head>
<body>
  <header class="header">
    <h1>قوانين تراخيص المدارس</h1>
  </header>

  <nav class="navbar">
    <a href="#section1">الموضوع الأول</a>
    <a href="#section2">الموضوع الثاني</a>
    <a href="#section3">الموضوع الثالث</a>
    <a href="#section4">الموضوع الرابع</a>
    <a href="#section4">الموضوع الخامس</a>
    <a href="#section4">الموضوع السادس</a>

  </nav>

  <main class="content">
    <section id="section1" class="section">
      <h2>الباب الأول</h2>
      <p>
       
📘 الباب الأول: التسمية والتعاريف
<br><br>
<h3>1. المادة 1 – التسمية
</h3><br><br>
يُسمّى هذا القانون: (قانون تنظيم مؤسسات التعليم الأهلية والخاصة)  .
<br><br>
<h3>2. المادة 2 – التعاريف
</h3><br><br>
تُقابَل المصطلحات التالية بمعانيها الواردة في سياق هذا القانون:
<br><br>
"الجمهورية": الجمهورية اليمنية.
<br><br>
"الوزارة": وزارة التربية والتعليم.
<br><br>
"القانون": هذا القانون المنظّم لمؤسسات التعليم الأهلي والخاصة.
<br><br>
"قانون التعليم": القانون العام للتربية والتعليم.
<br><br>
"المدارس الحكومية": المدارس التي تمولها وتديرها الحكومة تحت إشراف الوزارة.
<br><br>
"مؤسسات التعليم الأهلية": تتضمّن رياض الأطفال والمدارس الأساسية والثانوية والمعاهد والمراكز التخصصية التي ينشئها أفراد أو جهات خاصة ويموّلونها.
<br><br>
"مؤسسات التعليم الخاصة": التي تنشأ بغرض تعليم أبناء الجاليات المقيمة في البلاد.
<br><br>
"مدارس الجاليات": تُنشأ لتعليم أبناء الجاليات اليمنية في الخارج.
<br><br>
يشمل المصطلح أيضًا مدارس ذوي الإعاقة، الموهوبين، والمدارس المتخصصة والمعاهد والمراكز التدريبية  .
      </p>
    </section>
  
    
    <section id="section2" class="section">
      <h2>الموضوع الثاني</h2>
      <p>
        الباب الثاني: القواعد العامة – أهداف وإنشاء
<br><br>
<h3>3. المادة 3 – أهداف إنشاء مؤسسات التعليم الأهلي والخاصة
</h3><br><br>
تنشأ هذه المؤسسات لتحقيق الأغراض التالية:
<br><br>
1. إثراء الخيارات التعليمية إلى جانب الحكومة.
<br><br>
2. تأهيل الكوادر لتنمية الاقتصاد والمجتمع.
<br><br>
3. إدخال المرونة والابتكار في التعليم.
<br><br>
4. تعزيز دراسة اللغات الأجنبية.
<br><br>
5. توفير تنافس وتنوع تربوي.
<br><br>
6. تشجيع الاستثمار المحلي والأجنبي في التعليم.
<br><br>
7. خدمة أبناء الجاليات بما يتماشى مع مناهج بلدانهم  .

      </p>
    </section>
   
   
   
   
    <section id="section3" class="section">
      <h2>الموضوع الثالث</h2>
      <p>
       
 الباب الثالث: شروط منح التراخيص
<br><br>
<h3>4. المادة 4 – أهلية الطلبة والمؤسسين
</h3><br><br>
يجب أن يكون المؤسسون من اليمنيين أو من دول صديقة، أو جهات خارجية بموجب اتفاقيات.
<br><br>
يشترط أن يكون للمؤسس خبرة أكاديمية أو تعليمية تتيح له تقديم أساليب تعليمية مبتكرة  .
<br><br>
<h3>5. المادة 5 – الرخصة وشرائطها
</h3><br><br>
تُمنح الرخصة إذا كانت تقدم خدمة تعليمية تخدم المجتمع المحلي (مرحلة ما قبل المدرسة حتى الثانوية)  .
<br><br>
يُمنع الترخيص لأي مؤسسة مرتبطة بمنظمات دينية أو سياسية تخدم أغراض متطرفة  .
<br><br>
<h3>6. المادة 7 – شروط متعلقة بإصدار الترخيص
</h3><br><br>
على مقدم الطلب تقديم:
<br><br>
دراسة جدوى اقتصادية واجتماعية وتربوية.
<br><br>
تحديد مصادر التمويل والرسوم.
<br><br>
برامج تعليمية، وخطط تدريس، وجودة المعلمين والإداريين.
<br><br>
ضمان توافق المناهج مع القيم الدينية والوطنية وقانون التعليم  .

      </p>
    </section>
   
   
    <section id="section4" class="section">
      <h2>الموضوع الرابع</h2>
      <p>📘 الباب الرابع: الإشراف والتوجيه والرقابة
<br><br>
<h3>المادة 8 – إشراف الوزارة
</h3><br><br>
تخضع جميع مؤسسات التعليم الأهلي والخاصة لإشراف وزارة التربية والتعليم، وفقًا للقوانين واللوائح النافذة، وتشمل مهام الإشراف:
<br><br>
1. التأكد من التزام المؤسسة بالمناهج والسياسات التعليمية العامة.
<br><br>
2. مراجعة الأداء التربوي والإداري والمالي.
<br><br>
3. التأكد من أن الكوادر التعليمية مؤهلة وتمتلك الخبرة المناسبة.
<br><br>
4. متابعة الشكاوى والملاحظات المرفوعة من الطلاب أو أولياء الأمور.
<br><br>

<h3>المادة 9 – أدوات التوجيه والرقابة
</h3><br><br>
تستخدم الوزارة الوسائل التالية في التوجيه والرقابة:
<br><br>
الزيارات الدورية من قبل مفتشين تربويين.
<br><br>
تقديم تقارير تقييم سنوية تشمل أداء المدرسة والمعلمين والإدارة.
<br><br>
إجراء اختبارات وزارية موحدة للتأكد من المستوى العلمي للطلاب.
<br><br>

<h3>المادة 10 – إلزام المؤسسات بالتقارير
</h3><br><br>
تُلزم مؤسسات التعليم الأهلي والخاصة بـ:
<br><br>
1. تقديم خططها السنوية التعليمية والإدارية إلى الوزارة.
<br><br>
2. تقديم تقارير نصف سنوية وسنوية عن الأداء.
<br><br>
3. الإفصاح عن مصادر التمويل والمصاريف السنوية.</p>
    </section>

     <section id="section5" class="section">
      <h2>الموضوع الخامس </h2>
      <p>
        📘 الباب الخامس: حقوق وواجبات المؤسسات

<h3>المادة 11 – الحقوق</h3>
<br><br>
لمؤسسات التعليم الأهلي والخاصة الحق في:
<br><br>
1. اختيار طواقمها التعليمية والإدارية بما لا يخالف شروط الوزارة.
<br><br>
2. تحديد رسوم دراسية مناسبة مع موافقة الوزارة.
<br><br>
3. اعتماد مناهج إضافية (كاللغات أو المهارات) شرط عدم تعارضها مع المنهج الوطني.
<br><br>
<h3>المادة 12 – الواجبات</h3>
<br><br>
تلتزم المؤسسات بما يلي:
<br><br>
1. تطبيق المناهج المعتمدة من الوزارة وعدم إدخال مناهج دون تصريح.
<br><br>
2. احترام المبادئ الدينية والوطنية والثقافية في التعليم.
<br><br>
3. توفير بيئة آمنة وصحية للتعليم.
<br><br>
4. الالتزام بالرسوم التي تم اعتمادها وعدم رفعها بدون موافقة رسمية.
<br><br>


<h3>المادة 13 – العقوبات في حالة المخالفة</h3>
<br><br>
تُتّخذ الإجراءات التالية حسب طبيعة المخالفة:
<br><br>
1. إنذار كتابي أول.
<br><br>
2. إنذار ثانٍ مع مهلة تصحيح الوضع.
<br><br>
3. إيقاف الترخيص مؤقتًا.
<br><br>
4. إلغاء الترخيص نهائيًا في حال استمرار المخالفة.

      </p>
      </section>

      <section id="section6" class="section">
      <h2>الموضوع السادس</h2>
  <p>
   <h2> 📘 الباب السادس: الرسوم والتراخيص والأحكام العامة</h2>
<br><br>
<h3>المادة 14 – الرسوم الدراسية</h3>
<br><br>
1. يجب على كل مؤسسة تعليمية أهلية أو خاصة تقديم كشف بالرسوم الدراسية ومصاريف الخدمات السنوية إلى وزارة التربية والتعليم لاعتمادها.
<br><br>
2. لا يجوز رفع الرسوم إلا بموافقة خطية من الوزارة بعد دراسة مبررات الزيادة.
<br><br>
3. يجب إعلان الرسوم الدراسية للطلاب وأولياء الأمور بشكل واضح وشفاف قبل بداية كل عام دراسي.
<br><br>
4. يمنع فرض رسوم إضافية على الطلاب خلال العام الدراسي دون تصريح رسمي.
<br><br>
<h3>المادة 15 – إجراءات منح الترخيص</h3>
<br><br>
للحصول على الترخيص، يجب على مقدم الطلب:
<br><br>
1. تعبئة نموذج طلب الترخيص المعد من الوزارة.
<br><br>
2. إرفاق خطة تربوية وإدارية وهيكل تنظيمي.
<br><br>
3. تقديم عقد ملكية أو إيجار للمقر التعليمي.
<br><br>
4. الالتزام بشروط البناء المدرسي من حيث السلامة، المساحة، التهوية، دورات المياه، الملاعب.
<br><br>
5. دفع رسوم الترخيص التي تحددها الوزارة.
<br><br>

<h3>المادة 16 – مدة الترخيص وتجديده</h3>
<br><br>
1. يُمنح الترخيص لمدة عامين دراسيين قابلة للتجديد.
<br><br>
2. يجب تقديم طلب التجديد قبل نهاية الترخيص بـ 60 يومًا.
<br><br>
3. يحق للوزارة عدم تجديد الترخيص في حال وجود مخالفات متكررة أو ضعف في الأداء التربوي.
<br><br>
4. يتم تعليق أو إلغاء الترخيص بناءً على تقرير لجنة إشراف وتقييم معتمدة من الوزارة.
<br><br>

<h3>المادة 17 – حالات إلغاء الترخيص</h3>
<br><br>
يُلغى الترخيص إذا:
<br><br>
1. ثبت تقديم بيانات غير صحيحة للحصول على الترخيص.
<br><br>
2. تم استخدام المؤسسة لأغراض مخالفة للعملية التعليمية.
<br><br>
3. فشلت المؤسسة في تصحيح المخالفات رغم الإنذارات الرسمية.
<br><br>
4. أصبحت المؤسسة تمثل خطرًا على الطلاب (بسبب بيئة غير آمنة أو ضعف تربوي حاد).

  </p>
      </section>

       <section id="section7" class="section">
      <h2>الموضوع السابع</h2>
      <p>

<h2>الباب السابع: أحكام ختامية</h2>📘 
<br><br>
المادة 18 – سحب الاعتراف بالمخرجات
<br><br>
يحق للوزارة:
<br><br>
سحب الاعتراف بالشهادات أو مخرجات أي مؤسسة تعليمية في حال ثبوت أنها لم تلتزم بالمعايير التربوية أو استعملت وسائل احتيالية في منح الشهادات.
<br><br>
<h3>المادة 19 – تسوية الأوضاع</h3>
<br><br>
تُمنح المؤسسات غير المرخصة التي تعمل قبل صدور هذا القانون مهلة أقصاها سنة واحدة لتسوية أوضاعها القانونية.
<br><br>
بعد هذه المدة، تُعتبر غير قانونية وتُغلق إداريًا.
<br><br>


<h3>المادة 20 – إصدار اللائحة التنفيذية</h3>المادة 20 – إصدار اللائحة التنفيذية
<br><br>
تصدر وزارة التربية والتعليم اللائحة التنفيذية لهذا القانون خلال مدة لا تتجاوز ستة أشهر من تاريخ صدوره.
<br><br>
تشمل اللائحة تفاصيل الإجراءات، النماذج، معايير التقييم، والمخالفات والجزاءات التفصيلية.
<br><br>


<h3>المادة 21 – سريان القانون</h3>
<br><br>
يُعمل بهذا القانون من تاريخ نشره في الجريدة الرسمية، وتُلغى كل الأحكام السابقة المخالفة له.

      </p>
      </section>
  </main>

  <footer class="footer">
    <p>&copy; 2025 موقع تراخيص. جميع الحقوق محفوظة.</p>
  </footer>
 
 
 
 
  <style>
    body {
      font-family: 'Cairo', sans-serif;
      margin: 0;
      padding: 0;
      background: #e6f7ff;
      color: #003366;
      direction: rtl;
    }

    .header {
      text-align: center;
      background: #005580;
      color: white;
      padding: 15px;
    }

    .navbar {
      display: flex;
      justify-content: center;
      background: #0099cc;
      padding: 10px;
    }

    .navbar a {
      color: white;
      text-decoration: none;
      margin: 0 15px;
      font-size: 16px;
      transition: color 0.3s;
    }

    .navbar a:hover {
      color: #ffcc00;
    }

    .content {
      padding: 20px;
    }

    .section {
      background: white;
      margin: 20px 0;
      padding: 15px;
      border-radius: 8px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
      opacity: 0;
      transform: translateY(50px);
      transition: opacity 0.8s ease-out, transform 0.8s ease-out;
    }

    .section.visible {
      opacity: 1;
      transform: translateY(0);
    }

    .footer {
      background: #003366;
      color: white;
      text-align: center;
      padding: 10px;
      margin-top: 20px;
    }

    .scroll-to-top {
      position: fixed;
      bottom: 10px;
      right: 10px;
      background: #005580;
      color: white;
      padding: 10px 15px;
      border-radius: 25px;
      cursor: pointer;
      font-size: 14px;
      display: none;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
      transition: background 0.3s, transform 0.3s;
    }

    .scroll-to-top:hover {
      background: #0099cc;
      transform: scale(1.1);
    }
  </style>

 
  <div class="scroll-to-top" id="scrollToTop">
    ⬆ الرجوع إلى الأعلى
  </div>
 
  <script>
    // الحصول على عنصر الزر
    const scrollToTopButton = document.getElementById('scrollToTop');
 
    // إظهار أو إخفاء الزر بناءً على موقع التمرير
    window.addEventListener('scroll', () => {
      if (window.scrollY > 200) { // إذا تجاوز المستخدم 200 بكسل في التمرير
        scrollToTopButton.style.display = 'block';
      } else {
        scrollToTopButton.style.display = 'none';
      }
    });
 
    // العودة إلى أعلى الصفحة عند الضغط على الزر
    scrollToTopButton.addEventListener('click', () => {
      window.scrollTo({
        top: 0,
        behavior: 'smooth' // يجعل الانتقال سلسًا
      });
    });
   
   
      // 1. إضافة تأثير الظهور التدريجي عند التمرير
      const sections = document.querySelectorAll('.section');
   
      const revealSections = () => {
        sections.forEach(section => {
          const sectionTop = section.getBoundingClientRect().top;
          const windowHeight = window.innerHeight;
   
          if (sectionTop < windowHeight - 100) {
            section.classList.add('visible');
          } else {
            section.classList.remove('visible');
          }
        });
      };
   
      window.addEventListener('scroll', revealSections);
   
      // 2. إضافة تأثير عند تمرير الماوس على الروابط
      const navLinks = document.querySelectorAll('.navbar a');
   
      navLinks.forEach(link => {
        link.addEventListener('mouseover', () => {
          link.style.transform = 'scale(1.2)';
          link.style.color = '#ffcc00';
        });
   
        link.addEventListener('mouseout', () => {
          link.style.transform = 'scale(1)';
          link.style.color = 'white';
        });
      });
   
      // 3. تأثير نص متغير في الشريط العلوي
      const headerTitle = document.querySelector('.header h1');
      const messages = ['قوانين تراخيص المدارس', 'مرحبًا بكم في موقعنا', 'نحن هنا لخدمتك'];
      let messageIndex = 0;
   
      setInterval(() => {
        messageIndex = (messageIndex + 1) % messages.length;
        headerTitle.textContent = messages[messageIndex];
      }, 3000);
   
    // يمكنك إضافة تأثيرات إضافية إذا أردت، مثل إيقاف الحركة عند التمرير فوق الشريط
const slider = document.querySelector('.slider');

// إيقاف الحركة عند التمرير على الصور
slider.addEventListener('mouseover', () => {
  slider.style.animationPlayState = 'paused';
});

// استئناف الحركة عند الخروج
slider.addEventListener('mouseout', () => {
  slider.style.animationPlayState = 'running';
});

  </script>
 
</body>
</html>