<table class="table table-bordered text-center align-middle">
    <thead class="table-light">
        <tr>
            <th>الرقم</th>
            <th>الصورة</th>
            <th>الاسم</th>
            <th>البريد الإلكتروني</th>
            <th>رقم الهاتف</th>
            <th>الجنس</th>
            <th>الخيارات</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($users as $user)
    <tr>
        <td>{{ $loop->iteration }}</td>
        <td>
            @if($user->image)
                <img src="{{ asset($user->image) }}" width="50" height="50" class="rounded-circle" alt="صورة">
            @else
                لا يوجد
            @endif
        </td>
        <td>{{ $user->name }}</td>
        <td>{{ $user->email }}</td>
        <td>{{ $user->phone }}</td>
        <td>
            {{ $user->gender == 'male' ? 'ذكر' : 'أنثى' }}
        </td>
        <td>{{ $user->city->name ?? 'غير محدد' }}</td>
        <td>
            <a href="{{ route('users.edit', $user->id) }}" class="btn btn-sm btn-primary">تعديل</a>
            <form action="{{ route('users.destroy', $user->id) }}" method="POST" style="display:inline-block;">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من الحذف؟')">حذف</button>
            </form>
        </td>
    </tr>
@endforeach
