@extends('admin.layout.master')

@section('content')


<div class="container" style="direction: rtl; font-family: 'Tahoma', sans-serif;">
    <h2 class="mb-4 text-center text-primary">📝 تعديل بيانات المستخدم</h2>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>⚠️ {{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('users.update', $user->id) }}" method="POST" enctype="multipart/form-data" class="bg-light p-4 rounded shadow-sm">
        @csrf
        @method('PUT')

        <div class="row">
            <!-- الاسم -->
            <div class="col-md-6 mb-3">
                <label>الاسم:</label>
                <input type="text" name="name" class="form-control" value="{{ $user->name }}" required>
            </div>

            <!-- البريد -->
            <div class="col-md-6 mb-3">
                <label>البريد الإلكتروني:</label>
                <input type="email" name="email" class="form-control" value="{{ $user->email }}">
            </div>

            <!-- الهاتف -->
            <div class="col-md-6 mb-3">
                <label>رقم الهاتف:</label>
                <input type="text" name="phone" class="form-control" value="{{ $user->phone }}">
            </div>

            <!-- كلمة المرور -->
            <div class="col-md-6 mb-3">
                <label>كلمة المرور (اتركها فارغة إن لم ترغب بتغييرها):</label>
                <input type="password" name="password" class="form-control">
            </div>

            <!-- الجنس -->
            <div class="col-md-6 mb-3">
                <label>الجنس:</label><br>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="gender" value="male" {{ $user->gender == 'male' ? 'checked' : '' }}>
                    <label class="form-check-label">ذكر</label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="gender" value="femal" {{ $user->gender == 'female' ? 'checked' : '' }}>
                    <label class="form-check-label">أنثى</label>
                </div>
            </div>

            <!-- المحافظة -->
            <div class="col-md-6 mb-3">
                <label>المحافظة:</label>
                <select name="city_id" class="form-control" required>
                    <option value=""> اختر المحافظة </option>
                    @foreach($cities as $city)
                        <option value="{{ $city->id }}" {{ $user->city_id == $city->id ? 'selected' : '' }}>
                            {{ $city->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <!-- صورة المستخدم -->
            <div class="col-md-6 mb-3">
                <label>الصورة الشخصية:</label>
                <input type="file" name="image" class="form-control">
                @if ($user->image)
                    <div class="mt-2">
                        <img src="{{ asset($user->image) }}" alt="الصورة الحالية" width="100" class="img-thumbnail">
                    </div>
                @endif
            </div>
        </div>

        <!-- زر الحفظ -->
        <div class="text-center mt-4">
            <button type="submit" class="btn btn-primary px-5">
                💾 حفظ التعديلات
            </button>
        </div>
    </form>
</div>


@endsection