@extends('admin.layout.master')

@section('content')




<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <title>إضافة مستخدم</title>

    <!-- Bootstrap RTL -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
</head>

<body style="direction: rtl; font-family: 'Tahoma', sans-serif; background-color: #f8f9fa;">

<div class="container mt-4 mb-5">
    <div class="card shadow-sm border-0">
        <div class="card-header bg-primary text-white">
            <h4 class="mb-0"><i class="bi bi-person-plus-fill"></i> إضافة مستخدم جديد</h4>
        </div>

        <div class="card-body bg-white">
            {{-- عرض رسائل الأخطاء --}}
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            {{-- النموذج --}}
            <form action="{{ route('users.store') }}" method="POST" enctype="multipart/form-data">
                @csrf

                <div class="row g-3">
                    <!-- الاسم -->
                    <div class="col-md-6">
                        <label class="form-label">الاسم:</label>
                        <input type="text" name="name" value="{{ old('name') }}" class="form-control" required>
                    </div>

                    <!-- البريد -->
                    <div class="col-md-6">
                        <label class="form-label">البريد الإلكتروني:</label>
                        <input type="email" name="email" value="{{ old('email') }}" class="form-control" required>
                    </div>

                    <!-- الهاتف -->
                    <div class="col-md-6">
                        <label class="form-label">رقم الهاتف:</label>
                        <input type="text" name="phone" value="{{ old('phone') }}" class="form-control">
                    </div>

                    <!-- كلمة المرور -->
                    <div class="col-md-6">
                        <label class="form-label">كلمة المرور:</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>

                    <!-- الجنس -->
                    <div class="col-md-6">
                        <label class="form-label d-block">الجنس:</label>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="gender" value="male" {{ old('gender') == 'male' ? 'checked' : '' }}>
                            <label class="form-check-label">ذكر</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="gender" value="femal" {{ old('gender') == 'femal' ? 'checked' : '' }}>
                            <label class="form-check-label">أنثى</label>
                        </div>
                    </div>

                    <!-- المحافظة -->
                    <div class="col-md-6">
                        <label class="form-label">اختر المحافظة:</label>
                        <select name="city_id" class="form-select" required>
                            <option value="">-- اختر المحافظة --</option>
                            @foreach($cities as $city)
                                <option value="{{ $city->id }}" {{ old('city_id') == $city->id ? 'selected' : '' }}>
                                    {{ $city->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- الصورة -->
                    <div class="col-md-6">
                        <label class="form-label">الصورة الشخصية:</label>
                        <input type="file" name="image" class="form-control">
                    </div>
                </div>

                <div class="text-center mt-4">
                    <button type="submit" class="btn btn-primary px-5">
                        <i class="bi bi-save2-fill"></i> حفظ المستخدم
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

</body>
</html>



@endsection