@extends('admin.layout.master')

@section('content')

<div class="card p-4">

    <h2 class="mb-4">إضافة مدرسة جديدة</h2>

    <form action="{{ route('schools.store') }}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="mb-3">
            <label for="school_name" class="form-label">اسم المدرسة:</label>
            <input type="text" name="school_name" id="school_name" class="form-control" required value="{{ old('school_name') }}">
        </div>

        <div class="mb-3">
            <label class="form-label">نوع المدرسة:</label><br>

         
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="type[]" id="pteparatory" value="pteparatory" {{ (is_array(old('type')) && in_array('pteparatory', old('type'))) ? 'checked' : '' }}>
                <label class="form-check-label" for="pteparatory">تمهيدي</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="type[]" id="primary" value="primary" {{ (is_array(old('type')) && in_array('primary', old('type'))) ? 'checked' : '' }}>
                <label class="form-check-label" for="primary">أساسي</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="type[]" id="middle" value="middle" {{ (is_array(old('type')) && in_array('middle', old('type'))) ? 'checked' : '' }}>
                <label class="form-check-label" for="middle">إعدادي</label>
            </div>
            <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="type[]" id="high" value="high" {{ (is_array(old('type')) && in_array('high', old('type'))) ? 'checked' : '' }}>
                <label class="form-check-label" for="high">ثانوي</label>
            </div>
        </div>

        <div class="mb-3">
            <label for="logo" class="form-label">شعار المدرسة :</label>
            <input type="file" name="logo" id="logo" class="form-control">
        </div>

        <div class="mb-3">
            <label for="city_id" class="form-label">اختر المحافظة:</label>
            <select name="city_id" id="city_id" class="form-select" required>
                <option value="">اختر المحافظة</option>
                @foreach ($cities as $city)
                    <option value="{{ $city->id }}" {{ old('city_id') == $city->id ? 'selected' : '' }}>{{ $city->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="user_id" class="form-label">اختر المستخدم المسؤول:</label>
            <select name="user_id" id="user_id" class="form-select" required>
                <option value="">اختر المستخدم</option>
                @foreach ($users as $user)
                    <option value="{{ $user->id }}" {{ old('user_id') == $user->id ? 'selected' : '' }}>{{ $user->name }}</option>
                @endforeach
            </select>
        </div>

        <button type="submit" class="btn btn-primary">حفظ</button>

    </form>

</div>

@endsection
