@extends('admin.layout.master')

@section('content')
<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="mb-0"><i class="bi bi-shield-lock"></i> أدوار المستخدمين</h4>
        
        <!-- نموذج البحث بالبريد الإلكتروني -->
        <form action="{{ route('users.roles') }}" method="GET" class="d-flex" style="max-width: 400px;">
            <div class="input-group">
                <input 
                    type="text" 
                    name="email" 
                    class="form-control" 
                    placeholder="البحث بالبريد الإلكتروني..."
                    value="{{ request('email') }}"
                >
                <button class="btn btn-primary" type="submit">
                    <i class="bi bi-search"></i> بحث
                </button>
                @if(request()->has('email'))
                    <a href="{{ route('users.roles', $user->id) }}" class="btn btn-secondary">
                        <i class="bi bi-arrow-counterclockwise"></i> إعادة تعيين
                    </a>
                @endif
            </div>
        </form>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if(request()->has('email') && $users->isEmpty())
        <div class="alert alert-warning">
            لم يتم العثور على أي مستخدمين للبريد الإلكتروني: "{{ request('email') }}"
        </div>
    @endif

    <table class="table table-bordered table-striped text-center">
        <thead class="table-primary">
            <tr>
                <th>الرقم</th>
                <th>الاسم</th>
                <th>البريد</th>
                <th>الدور / الأدوار</th>
                <th>الإجراء</th>
            </tr>
        </thead>
        <tbody>
            @forelse($users as $user)
            <tr>
                <td>{{ $user->id }}</td>
                <td>{{ $user->name }}</td>
                <td>{{ $user->email }}</td>
                <td>
                    @if($user->roles->count())
                        @foreach($user->roles as $role)
                            <span class="badge bg-info">{{ $role->name }}</span>
                        @endforeach
                    @else
                        <span class="text-muted">لا يوجد دور</span>
                    @endif
                </td>
                <td>
                    <a href="{{ route('users.assignRoleForm', $user->id) }}" class="btn btn-sm btn-primary">
                        <i class="bi bi-pencil-square"></i> تعيين دور
                    </a>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="5" class="text-muted">
                    @if(request()->has('email'))
                        لا توجد نتائج للبحث
                    @else
                        لا توجد مستخدمين
                    @endif
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection

