@extends('admin.layout.master')

@section('content')


<div class="card p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="mb-0">قائمة الصلاحيات</h2>
        <a href="{{ route('permissions.create') }}" class="btn btn-success">إضافة صلاحية جديدة</a>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered table-striped text-center">
        <thead class="table-light">
            <tr>
                <th>الرقم</th>
                <th>اسم الصلاحية</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($permissions as $index => $permission)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $permission->name }}</td>
                    <td>
                        <a href="{{ route('permissions.edit', $permission->id) }}" class="btn btn-sm btn-warning">تعديل</a>

                        <form action="{{ route('permissions.destroy', $permission->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من الحذف؟')">حذف</button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="3" class="text-muted">لا توجد صلاحيات حتى الآن</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

@endsection

