@extends('admin.layout.master')

@section('content')
<div class="card p-4">
    <h4 class="mb-4">تعديل الترخيص</h4>

    <form method="POST" action="{{ route('licenses.update', $license->id) }}"   enctype="multipart/form-data"">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label class="form-label">اسم الفرع</label>
            <select name="branche_id" class="form-select" required>
                @foreach ($branches as $branch)
                    <option value="{{ $branch->id }}" {{ $license->branche_id == $branch->id ? 'selected' : '' }}>
                        {{ $branch->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">الحالة</label>
            <select name="status" class="form-select" required>
                <option value="under_review" {{ $license->status == 'under_review' ? 'selected' : '' }}>قيد المراجعة</option>
                <option value="approved" {{ $license->status == 'approved' ? 'selected' : '' }}>مقبول</option>
                <option value="rejected" {{ $license->status == 'rejected' ? 'selected' : '' }}>مرفوض</option>
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">المستخدم الحالي</label>
            <select name="current_user_id" class="form-select" required>
                @foreach ($users as $user)
                    <option value="{{ $user->id }}" {{ $license->current_user_id == $user->id ? 'selected' : '' }}>
                        {{ $user->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">المستخدم التالي</label>
            <select name="next_user_id" class="form-select" required>
                @foreach ($users as $user)
                    <option value="{{ $user->id }}" {{ $license->next_user_id == $user->id ? 'selected' : '' }}>
                        {{ $user->name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label class="form-label">الملاحظة</label>
            <input type="text" name="note" class="form-control" value="{{ $license->note }}" required>
        </div>

        <div class="mb-3">
            <label class="form-label">الحالة النهائية</label>
            <input type="text" name="final_status" class="form-control" value="{{ $license->final_status }}" required>
        </div>



      <div class="form-group mt-3">
    <label for="approval_file">📄 ملف الموافقة (PDF من الوزارة)</label>
    <input type="file" name="approval_file" class="form-control" accept="application/pdf">

 
</div>

        <button type="submit" class="btn btn-primary">حفظ التعديلات</button>
    </form>
</div>
@endsection
