

@extends('admin.layout.master')

@section('content')







<div class="container mt-4">
    <div class="card shadow-sm">
        <div class="card-header bg-warning text-dark">
            <h5 class="mb-0">تعديل بيانات المدينة / المنطقة</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('cities.update', $city->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="mb-3">
                    <label for="name" class="form-label">اسم المدينة / المنطقة</label>
                    <input type="text" name="name" id="name" class="form-control" value="{{ $city->name }}" required>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> حفظ التعديلات
                    </button>
                    <a href="{{ route('cities.index') }}" class="btn btn-secondary ms-2">
                        <i class="bi bi-arrow-right-circle"></i> إلغاء
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>




@endsection