@extends('admin.layout.master')

@section('content')


<div class="container mt-4">
    <div class="card shadow-sm">
        <div class="card-header bg-success text-white">
            <h5 class="mb-0">إضافة مدينة / منطقة جديدة</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('cities.store') }}" method="POST">
                @csrf

                <div class="mb-3">
                    <label for="name" class="form-label">اسم المدينة / المنطقة</label>
                    <input type="text" name="name" id="name" class="form-control" placeholder="أدخل اسم المدينة" required>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save"></i> حفظ
                    </button>
                    <a href="{{ route('cities.index') }}" class="btn btn-secondary ms-2">
                        <i class="bi bi-arrow-right-circle"></i> رجوع
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>



@endsection