@extends('admin.layout.master')

@section('content')
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>{{ isset($branch) ? 'تعديل بيانات الفرع' : 'إضافة فرع مدرسة' }}</title>
<style>
    body {
        font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f0f2f5;
        margin: 20px;
        color: #2c3e50;
        font-size: 16px;
    }
    h2 {
        text-align: center;
        margin-bottom: 30px;
        font-size: 28px;
        color: #34495e;
    }
    .container {
        max-width: 1000px;
        margin: 0 auto;
        display: flex;
        gap: 30px;
        flex-wrap: wrap;
        justify-content: center;
    }
    .card {
        background: white;
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
        border-radius: 12px;
        padding: 25px 30px;
        box-sizing: border-box;
        flex: 1 1 450px;
        min-width: 320px;
    }
    form label {
        display: block;
        font-weight: 700;
        margin-top: 18px;
        margin-bottom: 8px;
        color: #34495e;
    }
    form input[type="text"],
    form select,
    form input[type="file"] {
        width: 100%;
        padding: 10px 14px;
        font-size: 15px;
        border-radius: 7px;
        border: 1px solid #ccc;
        box-sizing: border-box;
        transition: border-color 0.3s ease;
    }
    form input[type="text"]:focus,
    form select:focus,
    form input[type="file"]:focus {
        border-color: #2980b9;
        outline: none;
    }
    button.submit-btn {
        margin-top: 30px;
        width: 100%;
        background-color: #2980b9;
        color: white;
        font-size: 18px;
        font-weight: 700;
        padding: 14px 0;
        border: none;
        border-radius: 10px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }
    button.submit-btn:hover {
        background-color: #1c5980;
    }
    #map {
        width: 100%;
        height: 260px;
        border-radius: 10px;
        border: 1px solid #ccc;
        margin-top: 15px;
    }
    .current-file {
        margin-top: 5px;
        font-size: 14px;
        color: #2c3e50;
    }
    .current-file a {
        color: #2980b9;
        text-decoration: none;
    }
    .current-file a:hover {
        text-decoration: underline;
    }
</style>
</head>
<body>

<h2>{{ isset($branch) ? 'تعديل بيانات الفرع' : 'إضافة فرع مدرسة' }}</h2>

<form method="POST" action="{{ isset($branch) ? route('branches.update', $branch->id) : route('branches.store') }}" enctype="multipart/form-data">
    @csrf
    @if(isset($branch))
        @method('PUT')
    @endif

    <div class="container">
        <!-- العمود الأيمن: بيانات عامة -->
        <div class="card">
            <label for="school_id">اسم المدرسة:</label>
            <select name="school_id" id="school_id" required>
                <option value="">-- اختر المدرسة --</option>
                @foreach($schools as $school)
                    <option value="{{ $school->id }}" {{ (isset($branch) && $branch->school_id == $school->id) ? 'selected' : '' }}>
                        {{ $school->school_name }}
                    </option>
                @endforeach
            </select>

            <label for="area_id">اسم المنطقة:</label>
            <select name="area_id" id="area_id" required>
                <option value="">-- اختر المنطقة --</option>
                @foreach($areas as $area)
                    <option value="{{ $area->id }}" {{ (isset($branch) && $branch->area_id == $area->id) ? 'selected' : '' }}>
                        {{ $area->name }}
                    </option>
                @endforeach
            </select>

            <label for="name">اسم الفرع:</label>
            <input type="text" id="name" name="name" value="{{ $branch->name ?? '' }}" required />

            <label for="school_address">العنوان:</label>
            <input type="text" id="school_address" name="school_address" value="{{ $branch->school_address ?? '' }}" />

            <label for="nearest_landmark">أقرب معلم بارز:</label>
            <input type="text" id="nearest_landmark" name="nearest_landmark" value="{{ $branch->nearest_landmark ?? '' }}" />

            <label for="name_manage">اسم المدير:</label>
            <input type="text" id="name_manage" name="name_manage" value="{{ $branch->name_manage ?? '' }}" />

            <label for="phone_manage">رقم مدير الفرع:</label>
            <input type="text" id="phone_manage" name="phone_manage" value="{{ $branch->phone_manage ?? '' }}" />

            <label for="phone">رقم الفرع:</label>
            <input type="text" id="phone" name="phone" value="{{ $branch->phone ?? '' }}" />

            <label for="description">الوصف:</label>
            <input type="text" id="description" name="description" value="{{ $branch->description ?? '' }}" />
        </div>

        <!-- العمود الأيسر: الملفات والإحداثيات -->
        <div class="card">
            <label for="cv_manage">CV المدير (PDF):</label>
            <input type="file" id="cv_manage" name="cv_manage" accept="application/pdf" />
            @if(isset($branch) && $branch->cv_manage)
                <div class="current-file">
                    الملف الحالي: <a href="{{ asset('storage/'.$branch->cv_manage) }}" target="_blank">عرض الملف</a>
                </div>
            @endif

            <label for="contrect_image">صورة عقد الإيجار:</label>
            <input type="file" id="contrect_image" name="contrect_image" accept="image/*" />
            @if(isset($branch) && $branch->contrect_image)
                <div class="current-file">
                    الصورة الحالية: <a href="{{ asset('storage/'.$branch->contrect_image) }}" target="_blank">عرض الصورة</a>
                </div>
            @endif

            <label for="plan_image">صورة المخطط:</label>
            <input type="file" id="plan_image" name="plan_image" accept="image/*" />
            @if(isset($branch) && $branch->plan_image)
                <div class="current-file">
                    الصورة الحالية: <a href="{{ asset('storage/'.$branch->plan_image) }}" target="_blank">عرض الصورة</a>
                </div>
            @endif

            <label for="main_image">الصورة الرئيسية:</label>
            <input type="file" id="main_image" name="main_image" accept="image/*" />
            @if(isset($branch) && $branch->main_image)
                <div class="current-file">
                    الصورة الحالية: <a href="{{ asset('storage/'.$branch->main_image) }}" target="_blank">عرض الصورة</a>
                </div>
            @endif

            <label for="secondary_image">الصورة الثانوية:</label>
            <input type="file" id="secondary_image" name="secondary_image" accept="image/*" />
            @if(isset($branch) && $branch->secondary_image)
                <div class="current-file">
                    الصورة الحالية: <a href="{{ asset('storage/'.$branch->secondary_image) }}" target="_blank">عرض الصورة</a>
                </div>
            @endif

            <label for="file_feasibility">دراسة الجدوى:</label>
            <input type="file" id="file_feasibility" name="file_feasibility" />
            @if(isset($branch) && $branch->file_feasibility)
                <div class="current-file">
                    الملف الحالي: <a href="{{ asset('storage/'.$branch->file_feasibility) }}" target="_blank">عرض الملف</a>
                </div>
            @endif

            <label for="bank_statement">كشف الحساب البنكي:</label>
            <input type="file" id="bank_statement" name="bank_statement" />
            @if(isset($branch) && $branch->bank_statement)
                <div class="current-file">
                    الملف الحالي: <a href="{{ asset('storage/'.$branch->bank_statement) }}" target="_blank">عرض الملف</a>
                </div>
            @endif

            <label for="other_document">وثائق أخرى:</label>
            <input type="file" id="other_document" name="other_document" />
            @if(isset($branch) && $branch->other_document)
                <div class="current-file">
                    الملف الحالي: <a href="{{ asset('storage/'.$branch->other_document) }}" target="_blank">عرض الملف</a>
                </div>
            @endif

            <label for="latitude">خط العرض (Latitude):</label>
            <input type="text" id="latitude" name="latitude" value="{{ $branch->latitude ?? '' }}" required />

            <label for="longitude">خط الطول (Longitude):</label>
            <input type="text" id="longitude" name="longitude" value="{{ $branch->longitude ?? '' }}" required />

            <div id="map"></div>
        </div>
    </div>

    <button type="submit" class="submit-btn">{{ isset($branch) ? 'حفظ التعديلات' : 'حفظ الفرع' }}</button>
</form>

<script>
    let map;
    let marker;

    function initMap() {
        const latInput = document.getElementById("latitude");
        const lngInput = document.getElementById("longitude");

        const initialLat = parseFloat(latInput.value) || 15.3694;
        const initialLng = parseFloat(lngInput.value) || 44.1910;
        const initialPos = { lat: initialLat, lng: initialLng };

        map = new google.maps.Map(document.getElementById("map"), {
            center: initialPos,
            zoom: 13,
        });

        marker = new google.maps.Marker({
            position: initialPos,
            map: map,
            draggable: true
        });

        // تحديث الإحداثيات عند سحب العلامة
        marker.addListener('dragend', function(event) {
            latInput.value = event.latLng.lat();
            lngInput.value = event.latLng.lng();
        });

        // تحديث الإحداثيات عند الضغط على الخريطة
        map.addListener("click", function(e) {
            const clickedLat = e.latLng.lat();
            const clickedLng = e.latLng.lng();

            latInput.value = clickedLat;
            lngInput.value = clickedLng;

            marker.setPosition({ lat: clickedLat, lng: clickedLng });
        });
    }
</script>
<script src="https://maps.googleapis.com/maps/api/js?key={{ env('GOOGLE_MAPS_API_KEY') }}&callback=initMap" async defer></script>

</body>
</html>


@endsection
