@extends('admin.layout.master')

@section('title', 'قائمة الفروع - نظام إدارة الفروع')

@section('content')

    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css">
    <style>
        :root {
            --primary-color: #1a3a6c;
            --secondary-color: #2c5e92;
            --accent-color: #4a86e8;
            --light-color: #e9f0f7;
            --dark-color: #0a1f3a;
            --success-color: #28a745;
            --warning-color: #ffc107;
            --danger-color: #dc3545;
        }
        
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body {
            background-color: #f5f7fa;
            font-family: 'Cairo', sans-serif;
            direction: rtl;
            color: #333;
            line-height: 1.6;
        }

        .govt-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--dark-color) 100%);
            color: white;
            padding: 15px 30px;
            display: flex;
            align-items: center;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            border-bottom: 4px solid var(--accent-color);
        }
        
        .govt-logo {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .logo-img {
            width: 60px;
            height: 60px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 10px;
        }
        
        .logo-img img {
            max-width: 100%;
            max-height: 100%;
        }
        
        .govt-title {
            font-size: 22px;
            font-weight: 700;
        }
        
        .govt-subtitle {
            font-size: 16px;
            opacity: 0.9;
        }
        
        .container {
            max-width: 1400px;
            margin: 30px auto;
            padding: 0 20px;
        }
        
        .page-header {
            text-align: center;
            margin-bottom: 30px;
            padding: 25px;
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
            border-left: 5px solid var(--primary-color);
            position: relative;
            overflow: hidden;
        }
        
        .page-header::before {
            content: "";
            position: absolute;
            top: 0;
            right: 0;
            width: 100px;
            height: 100px;
            background: var(--light-color);
            border-radius: 50%;
            transform: translate(50%, -50%);
        }
        
        .page-header h1 {
            font-weight: 800;
            font-size: 32px;
            margin-bottom: 10px;
            color: var(--primary-color);
            position: relative;
            z-index: 2;
        }
        
        .page-header p {
            font-size: 18px;
            color: #555;
            max-width: 800px;
            margin: 0 auto;
            position: relative;
            z-index: 2;
        }
        
        .stats-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 4px 8px rgba(0,0,0,0.08);
            display: flex;
            align-items: center;
            gap: 15px;
            border-bottom: 4px solid var(--primary-color);
            transition: transform 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
        }
        
        .stat-icon {
            width: 60px;
            height: 60px;
            background: var(--light-color);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
            color: var(--primary-color);
        }
        
        .stat-content {
            flex: 1;
        }
        
        .stat-number {
            font-size: 32px;
            font-weight: 700;
            color: var(--primary-color);
            line-height: 1.2;
        }
        
        .stat-label {
            font-size: 16px;
            color: #666;
        }
        
        .add-button {
            display: flex;
            align-items: center;
            justify-content: center;
            width: fit-content;
            margin: 0 auto 30px;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 14px 35px;
            border-radius: 8px;
            font-size: 20px;
            font-weight: bold;
            text-decoration: none;
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.15);
            transition: all 0.3s ease;
            gap: 12px;
        }
        
        .add-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
            background: linear-gradient(135deg, #0a1f3a 0%, #1a3a6c 100%);
        }
        
        .table-container {
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.08);
            margin-bottom: 40px;
            border: 1px solid #e0e6ef;
        }
        
        .table-header {
            padding: 20px;
            background-color: var(--light-color);
            border-bottom: 1px solid #dee2e6;
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 15px;
        }
        
        .table-title {
            color: var(--dark-color);
            font-weight: bold;
            font-size: 22px;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .search-container {
            display: flex;
            gap: 10px;
        }
        
        .search-box {
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-family: 'Cairo', sans-serif;
            min-width: 250px;
        }
        
        .search-btn {
            background: var(--primary-color);
            color: white;
            border: none;
            border-radius: 6px;
            padding: 0 20px;
            cursor: pointer;
            font-family: 'Cairo', sans-serif;
            font-weight: bold;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
        }
        
        th {
            background-color: var(--primary-color);
            color: white;
            font-weight: bold;
            padding: 18px 15px;
            text-align: center;
            vertical-align: middle;
            border: none;
            position: sticky;
            top: 0;
        }
        
        td {
            padding: 16px 15px;
            text-align: center;
            vertical-align: middle;
            border-top: 1px solid #edf2f7;
            color: #2d3748;
        }
        
        tr:nth-child(even) {
            background-color: #f8fafc;
        }
        
        tr:hover {
            background-color: #edf2f7;
        }
        
        .file-link {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 5px;
            padding: 8px 14px;
            background-color: #edf2f7;
            border-radius: 6px;
            color: var(--secondary-color);
            font-weight: 600;
            text-decoration: none;
            transition: all 0.2s;
            margin: 3px;
            font-size: 14px;
        }
        
        .file-link:hover {
            background-color: var(--accent-color);
            color: white;
            transform: translateY(-2px);
        }
        
        .mini-map {
            height: 120px;
            width: 100%;
            border-radius: 8px;
            margin-top: 10px;
            border: 1px solid #ddd;
            background: #f8f9fa;
        }
        
        .map-placeholder {
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6c757d;
            flex-direction: column;
            gap: 10px;
        }
        
        .badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-weight: 600;
            display: inline-block;
        }
        
        .badge-primary {
            background-color: var(--primary-color);
            color: white;
        }
        
        .badge-secondary {
            background-color: #718096;
            color: white;
        }
        
        .actions-cell {
            min-width: 280px;
        }
        
        .license-section {
            background-color: #f1f7fe;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            border: 1px solid #dbe7f3;
        }
        
        .section-title {
            display: flex;
            align-items: center;
            gap: 8px;
            color: var(--primary-color);
            font-weight: bold;
            margin-bottom: 12px;
            font-size: 16px;
        }
        
        .license-actions {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            justify-content: center;
        }
        
        .license-item {
            background: white;
            border-radius: 8px;
            padding: 12px;
            margin-bottom: 12px;
            box-shadow: 0 3px 6px rgba(0,0,0,0.05);
            border: 1px solid #e2e8f0;
            width: 100%;
        }
        
        .license-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .license-title {
            font-weight: 600;
            color: var(--dark-color);
            display: flex;
            align-items: center;
            gap: 5px;
        }
        
        .action-buttons {
            display: flex;
            gap: 8px;
            justify-content: center;
            margin-top: 10px;
        }
        
        .btn {
            padding: 9px 16px;
            border-radius: 6px;
            font-weight: 600;
            font-size: 14px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 6px;
            transition: all 0.2s;
            border: none;
            cursor: pointer;
        }
        
        .btn-sm {
            padding: 7px 12px;
            font-size: 13px;
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            color: white;
        }
        
        .btn-primary:hover {
            background-color: var(--dark-color);
            transform: translateY(-2px);
        }
        
        .btn-success {
            background-color: var(--success-color);
            color: white;
        }
        
        .btn-warning {
            background-color: var(--warning-color);
            color: #212529;
        }
        
        .btn-danger {
            background-color: var(--danger-color);
            color: white;
        }
        
        .pagination-container {
            display: flex;
            justify-content: center;
            margin-top: 30px;
            padding: 20px 0;
        }
        
        .pagination {
            display: flex;
            list-style: none;
            gap: 8px;
        }
        
        .page-item {
            display: inline-block;
        }
        
        .page-link {
            display: block;
            padding: 8px 16px;
            background: white;
            border: 1px solid #ddd;
            border-radius: 6px;
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 600;
            transition: all 0.2s;
        }
        
        .page-item.active .page-link {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            color: white;
        }
        
        .page-link:hover {
            background-color: var(--light-color);
        }
        
        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: #718096;
        }
        
        .empty-state i {
            font-size: 60px;
            margin-bottom: 20px;
            color: #cbd5e0;
        }
        
        .govt-footer {
            background: var(--dark-color);
            color: white;
            padding: 25px;
            text-align: center;
            margin-top: 40px;
            border-top: 4px solid var(--accent-color);
        }
        
        .footer-content {
            max-width: 800px;
            margin: 0 auto;
            display: flex;
            flex-direction: column;
            gap: 15px;
        }
        
        .footer-links {
            display: flex;
            justify-content: center;
            gap: 20px;
            flex-wrap: wrap;
        }
        
        .footer-link {
            color: #a0c4ff;
            text-decoration: none;
            transition: color 0.3s;
        }
        
        .footer-link:hover {
            color: white;
        }
        
        @media (max-width: 1200px) {
            .table-container {
                overflow-x: auto;
            }
            
            table {
                min-width: 1000px;
            }
        }
    </style>

<div class="page-header">
    <h2>
        <i class="fas fa-map-marker-alt"></i>
        قائمة الفروع - نظام إدارة الفروع الحكومية
    </h2>
</div>

@if(session('success'))
    <div class="alert alert-success text-center alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle"></i> {{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

<!-- <a href="{{ route('branches.create') }}" class="add-button">
    <i class="fas fa-plus-circle"></i>
    إضافة فرع جديد
</a> -->

<div class="table-container">
    <div class="table-header">
        <h3 class="table-title">
            <i class="fas fa-building"></i>
            الفروع المسجلة في النظام
        </h3>
        <span class="badge badge-primary">
            <i class="fas fa-list"></i>
            العدد: {{ $branches->total() }}
        </span>
    </div>
    
    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th>الرقم</th>
                    <th>اسم الفرع</th>
                    <th>المدرسة</th>
                    <th>المنطقة</th>
                    <th>📍 العنوان</th>
                    <th>مدير الفرع</th>
                    <th>📞 الهاتف</th>
                    <th>🛠️ الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                @forelse($branches as $branch)
                <tr>
                    <td><span class="badge badge-secondary">{{ $branch->id }}</span></td>
                    <td><strong>{{ $branch->name }}</strong></td>
                    <td>{{ $branch->school->school_name ?? 'غير محدد' }}</td>
                    <td>{{ $branch->area->name ?? 'غير محدد' }}</td>
                    <td>
                        <div>{{ $branch->school_address }}</div>
                        <small class="text-muted">أقرب معلم: {{ $branch->nearest_landmark }}</small>
                    </td>
                    <td>
                        <div>{{ $branch->name_manage }}</div>
                        <small class="text-muted">{{ $branch->phone_manage }}</small>
                    </td>
                    <td>{{ $branch->phone }}</td>
                    <td>
                        <!-- <div class="d-flex flex-wrap gap-2 justify-content-center"> -->
                            <!-- @if($branch->cv_manage)
                                <a href="{{ asset('storage/'.$branch->cv_manage) }}" target="_blank" class="file-link" title="سيرة المدير">
                                    <i class="fas fa-file-pdf"></i> السيرة
                                </a>
                            @endif -->
                            
                            <!-- @if($branch->contrect_image)
                                <a href="{{ asset('storage/'.$branch->contrect_image) }}" target="_blank" class="file-link" title="عقد الفرع">
                                    <i class="fas fa-file-contract"></i> العقد
                                </a>
                            @endif
                            
                            @if($branch->main_image)
                                <a href="{{ asset('storage/'.$branch->main_image) }}" target="_blank" class="file-link" title=" الصورة الرئيسية للفرع">
                                    <i class="fas fa-map"></i> صورة المدرسة
                                </a>
                            @endif

                               @if($branch->plan_image)
                                <a href="{{ asset('storage/'.$branch->plan_image) }}" target="_blank" class="file-link" title="مخطط الفرع">
                                    <i class="fas fa-map"></i> المخطط
                                </a>
                            @endif -->
                                  <!-- @if($branch->file_feasibility)
                                <a href="{{ asset('storage/'.$branch->file_feasibility) }}" target="_blank" class="file-link" title=" دراسة الجدوى">
                                    <i class="fas fa-file-contract"></i> دراسة الجدوى
                                </a>
                            @endif

                                @if($branch->other_document)
                                <a href="{{ asset('storage/'.$branch->other_document) }}" target="_blank" class="file-link" title=" وثائق اخرى">
                                    <i class="fas fa-file-pdf"></i> وثائق اخرى
                                </a>
                            @endif
                            
                        </div> -->
                    <!-- </td>
                 
                    <td>  -->
                        <!-- <div>عرض: {{ $branch->latitude }}</div>
                        <div>طول: {{ $branch->longitude }}</div> -->
                    

                    <td class="actions-cell">
                        <div class="license-section">
                            <div class="section-title">
                                <i class="fas fa-file-alt"></i>
                                تراخيص الفرع
                            </div>
                            
                            @forelse ($branch->licenses as $license)
                                <div class="license-item">
                                    <div class="license-header">
                                        <div class="license-title">
                                            <i class="fas fa-certificate"></i>
                                            الترخيص {{ $loop->iteration }}
                                        </div>
                                      
                                    </div>
                                    
                                    <div class="action-buttons">
                                        <a href="{{ route('licenses.edit', $license->id) }}" class="btn btn-warning btn-sm">
                                            <i class="fas fa-edit"></i> تعديل
                                        </a>
                                        <a href="{{ route('admin.licenses.add', $license->id) }}" class="btn btn-primary btn-sm">
                                            <i class="fas fa-eye"></i> تفاصيل
                                        </a>
                                        <form action="{{ route('licenses.destroy', $license->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm">
                                                <i class="fas fa-trash-alt"></i> حذف
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            @empty
                                <div class="text-center py-2 text-muted">
                                    <i class="fas fa-exclamation-circle"></i>
                                    لا يوجد تراخيص مسجلة
                                </div>
                            @endforelse
                        </div>
                        
                        <div class="d-flex justify-content-center gap-2">
                          
                            </a>
                            <a href="{{ route('licenses.create', ['branch_id' => $branch->id,'school_id' => $branch->school->school_id]) }}" class="btn btn-success btn-sm">
                                <i class="fas fa-plus-circle"></i> إضافة ترخيص
                            </a>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="10" class="empty-state">
                        <i class="fas fa-building"></i>
                        <h4>لا توجد فروع مسجلة</h4>
                        <p>لم يتم إضافة أي فروع حتى الآن. قم بإضافة فرع جديد لبدء الإدارة.</p>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
<!-- 
@if($branches->hasPages())
<div class="pagination-container">
    {{ $branches->links() }}
</div>
@endif -->

@endsection
