

@extends('admin.layout.master')

@section('content')

<div class="container mt-4">
    <h4>تعيين دور للمستخدم: {{ $user->name }}</h4>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                   <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="POST" action="{{ route('users.assignRole', $user->id) }}">
        @csrf

        <div class="mb-3">
            <label for="role" class="form-label">اختر الدور:</label>
            <select name="role" id="role" class="form-select" required>
                @foreach($roles as $role)
                    <option value="{{ $role }}" {{ $user->hasRole($role) ? 'selected' : '' }}>
                        {{ $role }}
                    </option>
                @endforeach
            </select>
        </div>

        <button type="submit" class="btn btn-primary">حفظ</button>
        <a href="{{ route('users.index') }}" class="btn btn-secondary">عودة</a>
    </form>
</div>

@endsection
