@extends('admin.layout.master')

@section('content')

<div class="card p-4">
    <h2 class="mb-4">إضافة منطقة جديدة</h2>

    <form action="{{ route('areas.store') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label for="name" class="form-label">اسم المنطقة:</label>
            <input type="text" id="name" name="name" class="form-control" required>
        </div>

        <div class="mb-3">
            <label for="city_id" class="form-label">اختر المدينة:</label>
            <select id="city_id" name="city_id" class="form-select" required>
                @foreach($cities as $city)
                    <option value="{{ $city->id }}">{{ $city->name }}</option>
                @endforeach
            </select>
        </div>

        <button type="submit" class="btn btn-success">إضافة</button>
    </form>
</div>

@endsection
