<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {     Schema::disableForeignKeyConstraints();
        Schema::create('renewals', function (Blueprint $table) {
            $table->id();
            
            $table->unsignedBigInteger('school_id');
            $table->string('branch_name');
            $table->unsignedBigInteger('area_id');
            $table->json('sections');
            // المستندات الأساسية
            $table->string('teachers_documents')->nullable();
            $table->string('renewal_form')->nullable();
            $table->string('director_image')->nullable();
            // المستندات المالية
            $table->string('certificate_purchase_receipt')->nullable();
            $table->string('occupancy_receipt')->nullable();
            $table->string('stage_addition_receipt')->nullable();
            $table->string('community_contribution_receipt')->nullable();
            $table->string('book_purchase_receipt')->nullable();
            // مستندات إضافية
            $table->string('rental_contract_image')->nullable();
            $table->string('civil_defense_receipt')->nullable();
            $table->boolean('has_violations')->default(false);
            $table->string('violations')->nullable();
            $table->boolean('has_capacity_issue')->default(false);
            $table->string('capacity')->nullable();
            // الإحصائيات
            $table->string('students_count')->nullable();
            $table->string('classes_count')->nullable();
            $table->string('teachers_count')->nullable();
            $table->string('pass_count')->nullable();
            $table->string('fail_count')->nullable();
            $table->string('curriculums_count')->nullable();
            $table->string('class_hours')->nullable();
            $table->string('workforce_count')->nullable();
            $table->string('annual_assignment')->nullable();
            $table->string('owner_image')->nullable();
            $table->string('photo_gallery')->nullable();
            $table->string('official_authorization')->nullable();
            // معلومات النظام
            $table->unsignedBigInteger('user_id');
            $table->enum('status', ['قيد المراجعة', 'مقبول', 'مرفوض'])->default('قيد المراجعة');
            $table->text('notes')->nullable();
            $table->timestamps();
            
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('renewals');
    }
};
