<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::disableForeignKeyConstraints();
        Schema::create('branches', function (Blueprint $table) {
            $table->id();
            $table->foreignId('school_id')->constrained('schools')->onDelete('cascade');
            $table->string('name');
            $table->foreignId('area_id')->constrained('areas')->onDelete('cascade');
            $table->string('school_address');
            $table->string('nearest_landmark');
            $table->decimal('latitude',10,8);
            $table->decimal('longitude',11,8);
            $table->string('name_manage');
            $table->string('phone_manage');
            $table->string('cv_manage');//
            $table->string('phone');
            $table->string('description');
            $table->string('contrect_image');//
            $table->string('plan_image');//
            $table->string('main_image');
            $table->string('secondary_image');
            $table->string('file_feasibility');
            $table->string('bank_statement');
            $table->string('other_document');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('branches');
    }
};
