<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class RenewalStatusUpdated extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
        use Queueable, SerializesModels;

    public $renewal;



    public function __construct($renewal)
    {
       
        $this->renewal = $renewal;

    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Renewal Status Updated',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.renewal_status_updated',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
    



   public function build()
    {
        $mail = $this->subject('تحديث حالة طلب تجديد الترخيص')
                     ->view('emails.renewal_status_updated');

        // إرفاق الملف إذا الحالة "مقبول"
        if (!empty($this->renewal->admin_document) && $this->renewal->status === 'approved') {
            $path = storage_path('app/public/' . $this->renewal->admin_document);
            if (file_exists($path)) {
                $mail->attach($path, [
                    'as' => 'approval_file.' . pathinfo($path, PATHINFO_EXTENSION),
                    'mime' => mime_content_type($path),
                ]);
            }
        }

        return $mail;
    }
}

