<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\School;
use App\Models\User;
use Illuminate\Http\Request;

class SchoolController extends Controller
{
    public function index()
    {
        $schools = School::with('city', 'user')->get();
        return view('admin.school.all_school', compact('schools'));
    }

    public function create()
    {
        $cities = City::all();
        $users = User::all();
        return view('admin.school.add_school', compact('cities', 'users'));
    }

    public function store(Request $request)
    {
        $school = new School();
        $school->school_name = $request->school_name;

       
        $school->type = json_encode($request->type);

        if ($request->hasFile('logo')) {
            $school->logo = $request->file('logo')->store('logos', 'public');
        }

        $school->city_id = $request->city_id;
        $school->user_id = $request->user_id;

        $school->save();

        return redirect()->route('schools.index')->with('success', 'تمت إضافة المدرسة بنجاح');
    }

    public function edit($id)
    {
        $school = School::findOrFail($id);
        $cities = City::all();
        $users = User::all();

        return view('admin.school.edit_school', compact('school', 'cities', 'users'));
    }

    public function update(Request $request, $id)
    {
        $school = School::findOrFail($id);
        $school->school_name = $request->school_name;

        // ترميز الـ type إلى JSON
        $school->type = json_encode($request->type);

        if ($request->hasFile('logo')) {
            $school->logo = $request->file('logo')->store('logos', 'public');
        }

        $school->city_id = $request->city_id;
        $school->user_id = $request->user_id;

        $school->save();

        return redirect()->route('schools.index')->with('success', 'تم تعديل المدرسة بنجاح');
    }

    public function destroy($id)
    {
        $school = School::findOrFail($id);
        $school->delete();

        return redirect()->route('schools.index')->with('success', 'تم حذف المدرسة بنجاح');
    }



}
