<?php

namespace App\Http\Controllers;

use App\Models\Area;
use App\Models\Branch;
use App\Models\School;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;


class SchoolBranchController extends Controller
{
    //

        // عرض النموذج الخاص بإضافة الفرع (الخطوة الثانية)
    public function step2($school_id)
    {
        
        $school = School::find($school_id);
        $areas = Area::all();



        return view('client.license_step2', compact('school', 'areas'));
    }

       public function storeStep2(Request $request, $school_id)
    {
            $school = School::findOrFail($school_id);


        $request->validate([
            'school_id' => 'required|exists:schools,id',
            'name' => 'required|string|max:255',
            'area_id' => 'required|exists:areas,id',
            'school_address' => 'required|string',
            'nearest_landmark' => 'nullable|string',
            'latitude' => 'nullable|numeric',
            'longitude' => 'nullable|numeric',
            'name_manage' => 'nullable|string',
            'phone_manage' => 'nullable|string',
            'cv_manage' => 'nullable|file',
            'phone' => 'nullable|string',
            'description' => 'nullable|string',
            'contrect_image' => 'nullable|file',
            'plan_image' => 'nullable|file',
            'main_image' => 'nullable|file',
            'secondary_image' => 'nullable|file',
            'file_feasibility' => 'nullable|file',
            'bank_statement' => 'nullable|file',
            'other_document' => 'nullable|file',
        ]);

        $branch = new Branch();
        $branch->fill($request->except([
            'cv_manage',
            'contrect_image',
            'plan_image',
            'main_image',
            'secondary_image',
            'file_feasibility',
            'bank_statement',
            'other_document'
        ]));

        // رفع الملفات
        foreach ([
            'cv_manage', 'contrect_image', 'plan_image', 'main_image',
            'secondary_image', 'file_feasibility', 'bank_statement', 'other_document'
        ] as $field) {
            if ($request->hasFile($field)) {
                $branch->$field = $request->file($field)->store('branches', 'public');
            }
        }

        $branch->save();

    return redirect()->route('license.success')->with('success', 'تم حفظ بيانات الفرع بنجاح.');
}

}
