<?php

namespace App\Http\Controllers;

use App\Models\Renwel;
use Illuminate\Http\Request;

class RenewLicenseAdminController extends Controller
{
    //
        public function index()
    {
        $renewals = Renwel::with('school')->latest()->get();
        return view('admin.license_renewal.index', compact('renewals'));
    }

  public function show($id)
{
       $renwel = Renwel::findOrFail($id);

    $previous = Renwel::where('id', '<', $id)->orderBy('id', 'desc')->first();
    $next = Renwel::where('id', '>', $id)->orderBy('id')->first();

    return view('admin.renwels.show', compact('renwel', 'previous', 'next'));
}



    public function edit($id)
    {
        $renewal = Renwel::findOrFail($id);
        return view('admin.renewals.edit', compact('renewal'));
    }

    public function update(Request $request, $id)
    {
        $renewal = Renwel::findOrFail($id);

        $renewal->status = $request->status;
        $renewal->notes = $request->notes;

        if ($request->hasFile('approval_file')) {
            $filePath = $request->file('approval_file')->store('approval_files', 'public');
            $renewal->approval_file = $filePath;
        }

        $renewal->save();

        return redirect()->route('admin.renewals.index')->with('success', 'تم تحديث الطلب بنجاح.');
    }

    function updateStatus(Request $request, $id) {
             $request->validate([         'notes' => 'nullable|string',        
      
             'status' => 'nullable|in:مقبول,مرفوض,قيد المراجعة',     ]);   
             $renwel = Renwel::findOrFail($id);   
              $renwel->notes = $request->notes;   
              $renwel->status = $request->status; 

         $renwel->save();     
        return redirect()->route('admin.renwels.show', $id)->with('success', 'تم تحديث الحالة والملاحظات بنجاح'); }   
    
    
    
    
    
    
    
    
     public function destroy($id)
    {
        $renewal = Renwel::findOrFail($id);
        $renewal->delete();
        return redirect()->route('admin.renwels.index')->with('success', 'تم حذف الترخيص بنجاح');
    }
    
    
    }
