<?php

namespace App\Http\Controllers;

use App\Models\Renwel;
use Illuminate\Http\Request;

class RenewLicenseCommitteController extends Controller
{
    //

        public function index()
    {
        $renewals = Renwel::with('school.area')->latest()->get(); //  pagination للسرعة

        return view('committee.license_renewal.index', compact('renewals'));
    }

     // عرض تفاصيل طلب تجديد الترخيص
    public function show($id)
    {
        $renwel = Renwel::with('school.area')->findOrFail($id);

        $previous = Renwel::where('id', '<', $id)->orderBy('id', 'desc')->first();
        $next = Renwel::where('id', '>', $id)->orderBy('id')->first();

        return view('committee.license_renewal.show', compact('renwel', 'previous', 'next'));
    }



     public function update(Request $request, $id)
    {
           $renewal = Renwel::findOrFail($id);

    $renewal->status = $request->status;
    $renewal->notes = $request->notes;

    if ($request->hasFile('admin_document')) {
        $filePath = $request->file('admin_document')->store('admin_documents', 'public');
        $renewal->admin_document = $filePath;
    }

    $renewal->save();

    return redirect()->route('committee.renwels.index')->with('success', 'تم تحديث الطلب بنجاح.');
}

public function destroy($id)
{
    $renewal = Renwel::find($id);

    if (!$renewal) {
        return redirect()->route('committee.renwels.index')
                         ->with('error', 'طلب التجديد غير موجود.');
    }

    $renewal->delete();

    return redirect()->route('committee.renwels.index')
                     ->with('success', 'تم حذف طلب التجديد بنجاح.');
}
}
