<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\License;
use App\Models\Renwel;
use Illuminate\Support\Facades\Auth; // ✅ هذا هو الصحيح
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CommitteeDashboardController extends Controller
{
    public function dashboard()
    
    {
           $cities = City::all();
        $total = License::count();
        $approved = License::where('status', 'approved')->count();
        $rejected = License::where('status', 'rejected')->count();
        $under_review = License::where('status', 'under_review')->count();

        $recent_licenses = License::with(['branch.school'])->latest()->take(5)->get();

        return view('committee.dashboard', compact('total', 'approved', 'rejected', 'under_review', 'recent_licenses','cities'));
    }
    
public function index($status = null)
{
    // جلب المحافظات
    $cities = City::all();

    // الإحصائيات
    $total = License::count();
    $approved = License::where('status', 'approved')->count();
    $rejected = License::where('status', 'rejected')->count();
    $under_review = License::where('status', 'under_review')->count();

    // جلب الطلبات الحديثة مثلاً آخر 5 طلبات
    $recent_licenses = License::latest()->take(5)->get();

    // الترخيص حسب الحالة إذا وُجدت
    $query = License::with('branch');
    if ($status) {
        $query->where('status', $status);
    }
    $licenses = $query->get();

    return view('committee.licenses.index', compact(
        'licenses', 'status', 'cities',
        'total', 'approved', 'rejected', 'under_review', 'recent_licenses'
    ));

    
}



    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('login'); // يمكنك تغييره لمسار تسجيل الدخول المخصص للجنة
    }


    
// عرض جميع التراخيص مرتبة من الأحدث إلى الأقدم
    public function allLicenses()
    {
        $licenses = License::with(['branch.school'])
            ->orderBy('created_at', 'desc')
            ->get();

        return view('committee.licenses.index', compact('licenses'));
    }

    // عرض ترخيص معين بالتفصيل
    public function show($id)
    {
        $license = License::with(['branch.school'])->findOrFail($id);

        return view('committee.licenses.add', compact('license'));
    }

    // عرض التراخيص حسب المحافظة
    public function showByCity($city_id)
    {
        $licenses = License::whereHas('branch.school.city', function ($query) use ($city_id) {
            $query->where('id', $city_id);
        })
            ->with(['branch.school'])
            ->orderBy('created_at', 'desc')
            ->get();

        return view('committee.city.by_city', compact('licenses'));
    }
public function renewalByCity()
    {
  $data = DB::table('cities')
        ->leftJoin('schools', 'cities.id', '=', 'schools.city_id')
        ->leftJoin('renewals', 'schools.id', '=', 'renewals.school_id')
        ->select('cities.id', 'cities.name', DB::raw('COUNT(renewals.id) as renewals_count'))
        ->groupBy('cities.id', 'cities.name')
        ->get();



        return view('committee.city.renewal_city', compact('data'));
    }

    public function showCity($cityId)
{
    $renewals = Renwel::whereHas('school', function($query) use ($cityId) {
        $query->where('city_id', $cityId);
    })->with('school')->get();

    $city = City::findOrFail($cityId);

    return view('committee.city.byCity', compact('renewals', 'city'));
}

}
