<?php

namespace App\Http\Controllers;

use App\Models\Branch;
use App\Models\License;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\LicenseStatusUpdated;

use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class CommitteLicenseController extends Controller
{
    //
        // عرض تفاصيل ترخيص محدد
         // عرض جميع التراخيص للجنة
       // عرض كل التراخيص
     // عرض كل التراخيص
       
     public function index($status = null)
{
      $recent_licenses = License::latest()->take(5)->get();
      
    $licenses = License::with(['school','branch', 'currentUser', 'nextUser'])->get();
    $query = License::with('branch');

    if ($status) {
        $query->where('status', $status);
    }

    $licenses = $query->get();


    return view('committee.licenses.index', [
        'licenses' => $licenses,
        'status' => $status
    ]);
    
}


    //    public function hh()
    //  {
    //     $licenses = License::with(['branch', 'currentUser', 'nextUser'])->get();
    //     return view('committee.licenses.add', compact('licenses'));
    //  }


    public function create()
    {
        $branches = Branch::all();
      $users = User::whereHas('roles', function ($query) {
    $query->where('name', 'committee_member');
          })->get();

        return view('committee.licenses.create', compact('branches', 'users'));
    }

   public function show($id)
{
    $license = License::with(['branch', 'currentUser', 'nextUser'])->findOrFail($id);
    $branch = $license->branch;

    $files = [
        'السيرة الذاتية لمدير المدرسة' => $branch->cv_manage,
        'عقد الإيجار' => $branch->contrect_image,
        'مخطط مبنى المدرسة (اختياري)' => $branch->plan_image,
        'الصورة الرئيسية' => $branch->main_image,
        'الصور الفرعية' => $branch->secondary_image,
        'دراسة الجدوى' => $branch->file_feasibility,
        'كشف الحساب البنكي' => $branch->bank_statement,
        'وثائق أخرى' => $branch->other_document,
    ];

    return view('committee.licenses.show', compact('license', 'files'));
}


public function add($id)

{

    $license = License::with([
    'branch.school.city',
    'branch.area.city',
    'currentUser',
    'nextUser'
])->findOrFail($id);



      

        // جلب كل المستخدمين للجنة لاختيار المستخدم الحالي والتالي
      $users = User::whereHas('roles', function ($query) {
    $query->where('name', 'committee_member');
        })->get();


        return view('committee.licenses.add', compact('license', 'users'));
    }

    // تبع الاي الاول

public function updateStatus(Request $request, $id)
{
    $request->validate([
        'status' => 'nullable|string',
        'final_status' => 'nullable|string',
        'note' => 'nullable|string',
        'current_user_id' => 'nullable|exists:users,id',
        'next_user_id' => 'nullable|exists:users,id',
        'approval_file' => 'nullable|file|mimes:pdf|max:2048', 
    ]);

    $license = License::findOrFail($id);

    $license->status = $request->status;
    $license->final_status = $request->final_status;
    $license->note = $request->note;
    $license->current_user_id = $request->current_user_id;
    $license->next_user_id = $request->next_user_id;

    // ✅ رفع ملف الموافقة
    if ($request->hasFile('approval_file')) {
        $file = $request->file('approval_file');
        $filename = time() . '_' . $file->getClientOriginalName();
        $path = $file->storeAs('approval_files', $filename, 'public');
        $license->approval_file = $path;
    }
        //  تحقق من وجود الترخيص
  

    // تحديث الحالة
    $license->status = $request->input('status');
    $license->save();

    //  الوصول إلى المستخدم المرتبط بالمدرسة
       $school = $license->school;
    if ($school && $school->user && $school->user->email) {
        //  إرسال إشعار بالبريد الإلكتروني
        Mail::to($school->user->email)->send(new LicenseStatusUpdated($license));
    }
    $license->save();
    // 5. إعادة التوجيه مع رسالة نجاح


    return redirect()->route('committee.licenses.index')->with('success','تم تحديث حالة الترخيص، وتم إرسال إشعار بالبريد الإلكتروني.');
    // return redirect()->back()->with('success', 'تم تحديث حالة الترخيص، وتم إرسال إشعار بالبريد الإلكتروني.');




  
}












//يحفظ لي تبع الجداول في الشاشة الرئيسه


    public function store(Request $request)
    {
        $request->validate([
            'branch_id' => 'required|exists:branches,id',
             'school_id' => 'required|exists:schools,id',
            'status' => 'required|string',
            'current_user_id' => 'nullable|exists:users,id',
            'next_user_id' => 'nullable|exists:users,id',
            'note' => 'nullable|string',
            'final_status' => 'nullable|string',
        ]);

        License::create($request->all());
        return redirect()->route('licenses.index')->with('success', 'تم إنشاء الترخيص بنجاح');
    }

public function edit($id)
{

    
    $license = License::findOrFail($id);
    $users = User::whereHas('roles', function ($query) {
    $query->where('name', 'committee_member');
     })->get();

    return view('committee.licenses.edit', compact('license','users'));
}
    public function update(Request $request, $id)
    {
        // جلب الترخيص مع العلاقات
        $license = License::with('branch.school', 'user')->findOrFail($id);

        // التحقق من صحة البيانات
        $request->validate([
            'status' => 'required|in:under_review,approved,rejected',
            'note' => 'nullable|string',
            'final_status' => 'nullable|string',
            'approval_file' => 'nullable|file|mimes:pdf|max:2048',
        ]);

        // تحديث القيم
        $license->status = $request->status;
        $license->note = $request->note;
        $license->final_status = $request->final_status;

        // رفع ملف الموافقة
        if ($request->hasFile('approval_file')) {
            if ($license->approval_file) {
                Storage::disk('public')->delete($license->approval_file);
            }
            $file = $request->file('approval_file');
            $filename = time() . '_' . $file->getClientOriginalName();
            $path = $file->storeAs('approval_files', $filename, 'public');
            $license->approval_file = $path;
        }

        $license->save();

        // إرسال الإيميل
        if ($license->user && $license->user->email) {
            try {
                Mail::to($license->user->email)
                    ->send(new LicenseStatusUpdated($license));
            } catch (\Exception $e) {
                Log::error("فشل إرسال البريد لترخيص رقم {$license->id}: " . $e->getMessage());
            }
        }


    return redirect()->route('committee.licenses.index')->with('success','تم تحديث حالة الترخيص، وتم إرسال إشعار بالبريد الإلكتروني.');
    
    }



    public function destroy($id)
    {
        $license = License::findOrFail($id);
        $license->delete();
        return redirect()->route('committee.licenses.index')->with('success', 'تم حذف الترخيص بنجاح');
    }



    public function statusFilter($status)
{
    $licenses = License::where('status', $status)->get();

    return view('committee.licenses.filtered', compact('licenses', 'status'));
}



}
