<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\School;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
class ClientController extends Controller
{
    //

    
    public function create()
    {
        $cities = City::all();
        return view('client.license_step1', compact('cities'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'school_name' => 'required|string|max:255',
            'city_id' => 'required|exists:cities,id',
            'type' => 'required|array',
            'logo' => 'nullable|image|max:2048',
        ]);

        $school = new School();
        $school->school_name = $request->school_name;
        $school->city_id = $request->city_id;
        $school->type = json_encode($request->type);
        $school->user_id = Auth::id(); // تعيين المستخدم الحالي
        if ($request->hasFile('logo')) {
            $school->logo = $request->file('logo')->store('school_logos', 'public');
        }
        $school->save();

            // 3. الانتقال للصفحة الثانية
    return redirect()->route('client.license.step2',$school->id)->with('success', 'تم إدخال بيانات المدرسة بنجاح. يمكنك الآن متابعة الخطوة التالية.');
}


    public function step2($id)
    {
        $school = School::findOrFail($id);
        return view('client.license_step2', compact('school'));
    }
}

