<?php

namespace App\Http\Controllers;

use App\Models\City;
use Illuminate\Http\Request;

class CityController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
          $cities = City::all();
        return view('admin.city.all_city', compact('cities'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        $cities = City::all();
        return view('admin.city.add_city', compact('cities'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
         $cities = new City();
        $cities->name = $request->name;
        $cities->save();
        return redirect()->route('cities.index')->with('success', 'تمت إضافة المدرسة بنجاح');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        $city = City::findOrFail($id);
        return view('admin.city.edit_city', compact('city'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $cities = City::findOrFail($id);
        $cities->name = $request->name;
        $cities->save();
        return redirect()->route('cities.index')->with('success', 'تم تعديل المدرسة بنجاح');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
         $cities = City::findOrFail($id);
        $cities->delete();

        return redirect()->route('cities.index')->with('success', 'تم حذف المدرسة بنجاح');
    }
}
