<?php

namespace App\Http\Controllers;

use App\Models\Area;
use App\Models\Branch;
use App\Models\License;
use App\Models\School;
use Illuminate\Http\Request;

class BrancheController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()

    {
        //
        
     $branches = Branch::with('school', 'area')->latest()->paginate(100); 
     
    return view('admin.branches.all_branche', compact('branches'));

    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    $schools = School::all(); 
    $areas = Area::all();     
    return view('admin.branches.add_branche', compact('schools', 'areas'));

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
                $request->validate([
            'school_id' => 'required|exists:schools,id',
            'name' => 'required|string|max:255',
            'area_id' => 'required|exists:areas,id',
            'school_address' => 'required|string',
            'nearest_landmark' => 'required|string',
            'latitude' => 'required|numeric',
            'longitude' => 'required|numeric',
            'name_manage' => 'required|string',
            'phone_manage' => 'required|string',
            'cv_manage' => 'required|file',
            'phone' => 'required|string',
            'description' => 'required|string',
            'contrect_image' => 'required|file',
            'plan_image' => 'required|file',
            'main_image' => 'required|file',
            'secondary_image' => 'required|file',
            'file_feasibility' => 'required|file',
            'bank_statement' => 'required|file',
            'other_document' => 'nullable|file',
        ]);

        // حفظ الملفات
        $branch = new Branch();
        $branch->school_id = $request->school_id;
        $branch->name = $request->name;
        $branch->area_id = $request->area_id;
        $branch->school_address = $request->school_address;
        $branch->nearest_landmark = $request->nearest_landmark;
        $branch->latitude = $request->latitude;
        $branch->longitude = $request->longitude;
        $branch->name_manage = $request->name_manage;
        $branch->phone_manage = $request->phone_manage;
        $branch->phone = $request->phone;
        $branch->description = $request->description;

        // رفع الملفات
        $branch->cv_manage = $request->file('cv_manage')->store('branches');
        $branch->contrect_image = $request->file('contrect_image')->store('branches');
        $branch->plan_image = $request->file('plan_image')->store('branches');
        $branch->main_image = $request->file('main_image')->store('branches');
        $branch->secondary_image = $request->file('secondary_image')->store('branches');
        $branch->file_feasibility = $request->file('file_feasibility')->store('branches');
        $branch->bank_statement = $request->file('bank_statement')->store('branches');
        if ($request->hasFile('other_document')) {
            $branch->other_document = $request->file('other_document')->store('branches');
        }

        $branch->save();

        return redirect()->route('branches.index')->with('success', 'تمت إضافة الفرع بنجاح');
    }

    

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        //
        $branch = Branch::findOrFail($id);
        $schools = School::all();
        $areas = Area::all();
         $license = License::findOrFail($id);
        return view('admin.branches.edit_branche', compact('branch', 'schools', 'areas'));

    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        //
        $branch = Branch::findOrFail($id);

        $branch->school_id = $request->school_id;
        $branch->name = $request->name;
        $branch->area_id = $request->area_id;
        $branch->school_address = $request->school_address;
        $branch->nearest_landmark = $request->nearest_landmark;
        $branch->latitude = $request->latitude;
        $branch->longitude = $request->longitude;
        $branch->name_manage = $request->name_manage;
        $branch->phone_manage = $request->phone_manage;
        $branch->phone = $request->phone;
        $branch->description = $request->description;

        // تحديث الملفات فقط إذا تم رفع جديد
        if ($request->hasFile('cv_manage')) {
            $branch->cv_manage = $request->file('cv_manage')->store('branches');
        }
        if ($request->hasFile('contrect_image')) {
            $branch->contrect_image = $request->file('contrect_image')->store('branches');
        }
        if ($request->hasFile('plan_image')) {
            $branch->plan_image = $request->file('plan_image')->store('branches');
        }
        if ($request->hasFile('main_image')) {
            $branch->main_image = $request->file('main_image')->store('branches');
        }
        if ($request->hasFile('secondary_image')) {
            $branch->secondary_image = $request->file('secondary_image')->store('branches');
        }
        if ($request->hasFile('file_feasibility')) {
            $branch->file_feasibility = $request->file('file_feasibility')->store('branches');
        }
        if ($request->hasFile('bank_statement')) {
            $branch->bank_statement = $request->file('bank_statement')->store('branches');
        }
        if ($request->hasFile('other_document')) {
            $branch->other_document = $request->file('other_document')->store('branches');
        }

        $branch->save();
      

        return redirect()->route('branches.index')->with('success', 'تم تعديل بيانات الفرع بنجاح');

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
        
        $branch = Branch::findOrFail($id);
        $branch->delete();

        return redirect()->route('branches.index')->with('success', 'تم حذف الفرع بنجاح');
    
    }
    public function indexWithLicenses()
{
    // جلب الفروع مع التراخيص المرتبطة بها
    $branches = Branch::with('licenses')->get();

    // إرسالها إلى صفحة العرض
    return view('admin.branches.all_branches', compact('branches'));
}

}
