<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class AdminAuthController extends Controller
{
   public function showLogin()
{
    

    return view('admin.auth.login');
}
public function login(Request $request)
{
    $credentials = $request->validate([
        'email' => ['required', 'email'],
        'password' => ['required'],
    ]);

    if (Auth::attempt($credentials, $request->filled('remember'))) {
        $request->session()->regenerate();
        $user = Auth::user();

        // جلب جميع الأدوار
        $roles = DB::table('role_user')
            ->join('roles', 'roles.id', '=', 'role_user.role_id')
            ->where('role_user.user_id', $user->id)
            ->pluck('roles.name')
            ->toArray();

        // التوجيه حسب الدور
        if (in_array('super_admin', $roles)) {
            return redirect()->route('admin.main_menus');
        } elseif (in_array('committee_member', $roles)) {
            return redirect()->route('committee.dashboard');
        } else {
            // أي دور غير السابقين
            return redirect()->route('client.home');
        }
    }

    return back()->withErrors([
        'email' => 'البريد الإلكتروني أو كلمة المرور غير صحيحة.',
    ])->withInput($request->only('email'));
}



    // public function register()
    // {
    //     $user = new User();
    //     $user->name = 'amani alkabous';
    //     $user->email = 'alkabous@gmail.com';
    //     $user->password = Hash::make('123456');
    //     $user->city_id = 1;
    //     $user->phone = '1234567';
    //     $user->image = 'amani.jpg';
    //     $user->save();

    //     $user->addRole('super_admin');
    // }

    public function logout(Request $request)
{
    Auth::logout(); 
    $request->session()->invalidate(); 
    $request->session()->regenerateToken(); 
    return redirect()->route('login'); 
}

}

